/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.h2;

import javax.servlet.Servlet;
import org.h2.server.web.WebServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.springframework.boot.autoconfigure.security.SecurityAuthorizeMode;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={WebServlet.class})
@ConditionalOnProperty(prefix="spring.h2.console", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={H2ConsoleProperties.class})
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
public class H2ConsoleAutoConfiguration {
    @Autowired
    private H2ConsoleProperties properties;

    @Bean
    public ServletRegistrationBean h2Console() {
        String path = this.properties.getPath();
        String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
        return new ServletRegistrationBean((Servlet)new WebServlet(), new String[]{urlMapping});
    }

    @Configuration
    @ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
    @ConditionalOnBean(value={ObjectPostProcessor.class})
    @ConditionalOnProperty(prefix="security.basic", name={"enabled"}, matchIfMissing=true)
    static class H2ConsoleSecurityConfiguration {
        H2ConsoleSecurityConfiguration() {
        }

        @Bean
        public WebSecurityConfigurerAdapter h2ConsoleSecurityConfigurer() {
            return new H2ConsoleSecurityConfigurer();
        }

        @Order(value=0x7FFFFFF0)
        private static class H2ConsoleSecurityConfigurer
        extends WebSecurityConfigurerAdapter {
            @Autowired
            private H2ConsoleProperties console;
            @Autowired
            private SecurityProperties security;

            private H2ConsoleSecurityConfigurer() {
            }

            public void configure(HttpSecurity http) throws Exception {
                String path = this.console.getPath();
                String antPattern = path.endsWith("/") ? path + "**" : path + "/**";
                HttpSecurity h2Console = http.antMatcher(antPattern);
                h2Console.csrf().disable();
                h2Console.httpBasic();
                h2Console.headers().frameOptions().sameOrigin();
                String[] roles = this.security.getUser().getRole().toArray(new String[0]);
                SecurityAuthorizeMode mode = this.security.getBasic().getAuthorizeMode();
                if (mode == null || mode == SecurityAuthorizeMode.ROLE) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).hasAnyRole(roles);
                } else if (mode == SecurityAuthorizeMode.AUTHENTICATED) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
                }
            }
        }
    }
}

