/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.inliner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.AbstractTextNode;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.inliner.IStandardTextInliner;

public abstract class AbstractStandardScriptingTextInliner
implements IStandardTextInliner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SCRIPT_ADD_INLINE_EVAL = "/\\*\\[\\+(.*?)\\+\\]\\*\\/";
    public static final Pattern SCRIPT_ADD_INLINE_EVAL_PATTERN = Pattern.compile("/\\*\\[\\+(.*?)\\+\\]\\*\\/", 32);
    public static final String SCRIPT_REMOVE_INLINE_EVAL = "\\/\\*\\[\\-(.*?)\\-\\]\\*\\/";
    public static final Pattern SCRIPT_REMOVE_INLINE_EVAL_PATTERN = Pattern.compile("\\/\\*\\[\\-(.*?)\\-\\]\\*\\/", 32);
    public static final String SCRIPT_VARIABLE_EXPRESSION_INLINE_EVAL = "\\/\\*(\\[\\[(.*?)\\]\\])\\*\\/([^\n]*?)\n";
    public static final Pattern SCRIPT_VARIABLE_EXPRESSION_INLINE_EVAL_PATTERN = Pattern.compile("\\/\\*(\\[\\[(.*?)\\]\\])\\*\\/([^\n]*?)\n", 32);
    public static final String SCRIPT_INLINE_EVAL = "\\[\\[(.*?)\\]\\]";
    public static final Pattern SCRIPT_INLINE_EVAL_PATTERN = Pattern.compile("\\[\\[(.*?)\\]\\]", 32);
    public static final String SCRIPT_INLINE_PREFIX = "[[";
    public static final String SCRIPT_INLINE_SUFFIX = "]]";

    protected AbstractStandardScriptingTextInliner() {
    }

    public final void inline(Arguments arguments, AbstractTextNode text) {
        String content = text.getOriginalContent();
        String javascriptContent = this.processScriptingInline(content, arguments);
        text.setContent(javascriptContent, true);
    }

    private String processScriptingInline(String input, Arguments arguments) {
        return this.processScriptingVariableInline(this.processScriptingVariableExpressionInline(this.processScriptingAddInline(this.processScriptingRemoveInline(input))), arguments);
    }

    private String processScriptingAddInline(String input) {
        Matcher matcher = SCRIPT_ADD_INLINE_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                String match = matcher.group(1);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[THYMELEAF][{}] Adding inlined javascript text \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)match);
                }
                strBuilder.append(match);
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString();
        }
        return input;
    }

    private String processScriptingRemoveInline(String input) {
        Matcher matcher = SCRIPT_REMOVE_INLINE_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                String match = matcher.group(1);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[THYMELEAF][{}] Removing inlined javascript text \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)match);
                }
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString();
        }
        return input;
    }

    private String processScriptingVariableExpressionInline(String input) {
        Matcher matcher = SCRIPT_VARIABLE_EXPRESSION_INLINE_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                strBuilder.append(matcher.group(1));
                strBuilder.append(AbstractStandardScriptingTextInliner.computeLineEndForInline(matcher.group(3)));
                strBuilder.append('\n');
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString();
        }
        return input;
    }

    private static String computeLineEndForInline(String lineRemainder) {
        if (lineRemainder == null) {
            return "";
        }
        char literalDelimiter = '\u0000';
        int arrayLevel = 0;
        int objectLevel = 0;
        int len = lineRemainder.length();
        for (int i = 0; i < len; ++i) {
            char c1;
            char c = lineRemainder.charAt(i);
            if (c == '\'' || c == '\"') {
                if (literalDelimiter == '\u0000' || i == 0) {
                    literalDelimiter = c;
                } else if (c == literalDelimiter && lineRemainder.charAt(i - 1) != '\\') {
                    literalDelimiter = '\u0000';
                }
            } else if (c == '{' && literalDelimiter == '\u0000') {
                ++objectLevel;
            } else if (c == '}' && literalDelimiter == '\u0000') {
                --objectLevel;
            } else if (c == '[' && literalDelimiter == '\u0000') {
                ++arrayLevel;
            } else if (c == ']' && literalDelimiter == '\u0000') {
                --arrayLevel;
            }
            if (literalDelimiter != '\u0000' || arrayLevel != 0 || objectLevel != 0) continue;
            if (c == ';' || c == ',' || c == ')') {
                return lineRemainder.substring(i);
            }
            if (c != '/' || i + 1 >= len || (c1 = lineRemainder.charAt(i + 1)) != '/' && c1 != '*') continue;
            return lineRemainder.substring(i);
        }
        return "";
    }

    private String processScriptingVariableInline(String input, Arguments arguments) {
        Matcher matcher = SCRIPT_INLINE_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            Configuration configuration = arguments.getConfiguration();
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(configuration);
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                String match = matcher.group(1);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[THYMELEAF][{}] Applying javascript variable inline evaluation on \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)match);
                }
                IStandardExpression expression = null;
                try {
                    expression = expressionParser.parseExpression(configuration, arguments, match);
                }
                catch (TemplateProcessingException ignored) {
                    strBuilder.append(SCRIPT_INLINE_PREFIX).append(match).append(SCRIPT_INLINE_SUFFIX);
                }
                if (expression != null) {
                    Object result = expression.execute(configuration, arguments);
                    strBuilder.append(this.formatEvaluationResult(result));
                }
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString();
        }
        return input;
    }

    protected abstract String formatEvaluationResult(Object var1);
}

