package com.ylzinfo.onepay.sdk;

import com.alibaba.fastjson.JSONObject;
import com.ylzinfo.onepay.sdk.domain.ResponseParams;
import com.ylzinfo.onepay.sdk.domain.ext.AccountQueryParams;
import com.ylzinfo.onepay.sdk.domain.ext.AccountQueryResult;
import com.ylzinfo.onepay.sdk.domain.ext.CardCheckParams;
import com.ylzinfo.onepay.sdk.domain.ext.CardCheckResult;
import com.ylzinfo.onepay.sdk.domain.ext.ConsumeCancelParams;
import com.ylzinfo.onepay.sdk.domain.ext.ConsumeCancelResult;
import com.ylzinfo.onepay.sdk.domain.ext.ConsumeParams;
import com.ylzinfo.onepay.sdk.domain.ext.ConsumeResult;
import com.ylzinfo.onepay.sdk.domain.ext.GetPutFileFeeParams;
import com.ylzinfo.onepay.sdk.domain.ext.GetPutFileFeeResult;
import com.ylzinfo.onepay.sdk.domain.ext.GetPutFileInfoParams;
import com.ylzinfo.onepay.sdk.domain.ext.GetPutFileInfoResult;
import com.ylzinfo.onepay.sdk.domain.ext.MMPayParam;
import com.ylzinfo.onepay.sdk.domain.ext.MMPayResult;
import com.ylzinfo.onepay.sdk.domain.ext.MedicalSettleParams;
import com.ylzinfo.onepay.sdk.domain.ext.MedicalSettleQueryParams;
import com.ylzinfo.onepay.sdk.domain.ext.MedicalSettleQueryResult;
import com.ylzinfo.onepay.sdk.domain.ext.MedicalSettleResult;
import com.ylzinfo.onepay.sdk.domain.ext.MmpPushResult;
import com.ylzinfo.onepay.sdk.domain.ext.OpenAccountParams;
import com.ylzinfo.onepay.sdk.domain.ext.OpenAccountResult;
import com.ylzinfo.onepay.sdk.domain.ext.PayForegiftParams;
import com.ylzinfo.onepay.sdk.domain.ext.PayForegiftResult;
import com.ylzinfo.onepay.sdk.domain.ext.PrepareRefundParams;
import com.ylzinfo.onepay.sdk.domain.ext.PrepareRefundResult;
import com.ylzinfo.onepay.sdk.domain.ext.PrintMediRecordParams;
import com.ylzinfo.onepay.sdk.domain.ext.PrintMediRecordResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryBalanceParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryBalanceResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryDetailParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryDetailResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryGuarderParam;
import com.ylzinfo.onepay.sdk.domain.ext.QueryGuarderResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryHeaSysAccountParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryHeaSysAccountResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryWaitPayParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryWaitPayResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryWaitVoucherParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryWaitVoucherResult;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeCloseParams;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeCloseResult;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeConsumeCancelParams;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeConsumeCancelResult;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeConsumeParams;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeConsumeResult;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeParams;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeResult;
import com.ylzinfo.onepay.sdk.domain.ext.RefundConfirmParams;
import com.ylzinfo.onepay.sdk.domain.ext.RefundConfirmResult;
import com.ylzinfo.onepay.sdk.domain.ext.RefundParams;
import com.ylzinfo.onepay.sdk.domain.ext.RefundResult;
import com.ylzinfo.onepay.sdk.domain.ext.RegisterTermParams;
import com.ylzinfo.onepay.sdk.domain.ext.RegisterTermResult;
import com.ylzinfo.onepay.sdk.domain.ext.SendSmsParams;
import com.ylzinfo.onepay.sdk.domain.ext.SendSmsResult;
import com.ylzinfo.onepay.sdk.domain.ext.SettleParams;
import com.ylzinfo.onepay.sdk.domain.ext.SettleResult;
import com.ylzinfo.onepay.sdk.domain.ext.TestCallParams;
import com.ylzinfo.onepay.sdk.domain.ext.TestCallResult;
import com.ylzinfo.onepay.sdk.domain.ext.TradeQueryParams;
import com.ylzinfo.onepay.sdk.domain.ext.TradeQueryResult;
import com.ylzinfo.onepay.sdk.domain.ext.WaitPayMainVO;
import com.ylzinfo.onepay.sdk.exception.PayException;
import com.ylzinfo.onepay.sdk.service.HisOnepayService;

/**
 * 医院支付平台
 * 
 * @author chenjh
 * 
 */
public class HisOnepayClient {

	/**
	 * 应用id
	 */
	private String appId;

	/**
	 * 应用安全key
	 */
	private String appSecret;

	/**
	 * 签名类型
	 */
	private String signType;

	/**
	 * 加密类型
	 */
	private String encryptType;

	/**
	 * 应用服务
	 */
	private HisOnepayService mainService;

	/**
	 * 医院统一支付平台入口，带支付平台地址构造
	 * 
	 * @param onepayUrl
	 *            支付平台地址
	 * @param appId
	 *            应用编号
	 * @param appSecret
	 *            应用密钥
	 */
	public HisOnepayClient(String onepayUrl, String appId, String appSecret, String signType, String encryptType) {
		super();
		this.appId = appId;
		this.appSecret = appSecret;
		mainService = new HisOnepayService(onepayUrl, appId, appSecret, signType, encryptType);
	}

	/**
	 * 应用与密钥构造
	 * 
	 * @param appId
	 * @param appSecret
	 */
	public HisOnepayClient(String appId, String appSecret, String signType, String encryptType) {
		super();
		this.appId = appId;
		this.appSecret = appSecret;
		mainService = new HisOnepayService(appId, appSecret, signType, encryptType);
	}

	public String getAppId() {
		return appId;
	}

	public String getAppSecret() {
		return appSecret;
	}

	public String getSignType() {
		return signType;
	}

	public String getEncryptType() {
		return encryptType;
	}

	/**
	 * 院内充值
	 * 
	 * @param rechargeParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<RechargeResult> recharge(RechargeParams rechargeParams) throws Exception {
		return mainService.recharge(rechargeParams);
	}

	/**
	 * 院内消费
	 * 
	 * @param consumeParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<ConsumeResult> consume(ConsumeParams consumeParams) throws Exception {
		return mainService.consume(consumeParams);
	}

	/**
	 * 院内消费撤销
	 * 
	 * @param consumeCancelParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<ConsumeCancelResult> consumeCancel(ConsumeCancelParams consumeCancelParams) throws Exception {
		return mainService.consumeCancel(consumeCancelParams);
	}

	/**
	 * 院内充值消费
	 * 
	 * @param rechargeConsumeParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<RechargeConsumeResult> rechargeConsume(RechargeConsumeParams rechargeConsumeParams) throws Exception {
		return mainService.rechargeConsume(rechargeConsumeParams);
	}

	/**
	 * 院内充值消费撤销
	 * 
	 * @param rechargeConsumeCancelParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<RechargeConsumeCancelResult> rechargeConsumeCancel(RechargeConsumeCancelParams rechargeConsumeCancelParams) throws Exception {
		return mainService.rechargeConsumeCancel(rechargeConsumeCancelParams);
	}

	/**
	 * 查询账户信息
	 * 
	 * @param accountQueryParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<AccountQueryResult> accountInfo(AccountQueryParams accountQueryParams) throws Exception {
		return mainService.accountInfo(accountQueryParams);
	}

	/**
	 * 查询交易结果
	 * 
	 * @param accountQueryParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<TradeQueryResult> tradeQuery(TradeQueryParams tradeQueryParams) throws Exception {
		return mainService.tradeQuery(tradeQueryParams);
	}

	/**
	 * 查询交易明细
	 * 
	 * @param accountQueryParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<QueryDetailResult> queryDetail(QueryDetailParams queryDetailParams) throws Exception {
		return mainService.queryDetail(queryDetailParams);
	}

	/**
	 * 卡号校验
	 * 
	 * @param param
	 * @return
	 */
	public ResponseParams<CardCheckResult> cardCheck(CardCheckParams param) throws Exception {
		return mainService.cardCheck(param);
	}

	/**
	 * 获取建档费用
	 * 
	 * @param param
	 * @return
	 */
	public ResponseParams<GetPutFileFeeResult> getPutFileFee(GetPutFileFeeParams param) throws Exception {
		return mainService.getPutFileFee(param);
	}

	/**
	 * 获取建档信息
	 * 
	 * @param param
	 * @return
	 */
	public ResponseParams<GetPutFileInfoResult> getPutFileInfo(GetPutFileInfoParams param) throws Exception {
		return mainService.getPutFileInfo(param);
	}

	/**
	 * 查询余额
	 * 
	 * @param param
	 * @return
	 */
	public ResponseParams<QueryBalanceResult> queryBalance(QueryBalanceParams param) throws Exception {
		return mainService.queryBalance(param);
	}

	/**
	 * 测试
	 * 
	 * @param params
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<TestCallResult> testCall(TestCallParams params) throws PayException {
		return mainService.testCall(params);
	}

	/**
	 * 注册终端 
	 * @param params
	 * @return
	 * @throws PayException 
	 */
	public ResponseParams<RegisterTermResult> registerTerm(RegisterTermParams params) throws PayException {
		return mainService.registerTerm(params);
	}
	
	
	/**
	 * 开户
	 * @param params
	 * @return
	 * @throws PayException 
	 */
	public ResponseParams<OpenAccountResult> openAccount(OpenAccountParams params) throws PayException {
		return mainService.openAccount(params);
	}

	/**
	 * 预退款
	 * @param param
	 * @return
	 * @throws PayException 
	 */
	public ResponseParams<PrepareRefundResult> prepareRefund(PrepareRefundParams params) throws PayException {
		return mainService.prepareRefund(params);
	}

	/**
	 * 院内退款确认
	 * 
	 * @param refundParams
	 * @return
	 * @throws Exception
	 */
	public ResponseParams<RefundConfirmResult> confirmRefund(RefundConfirmParams refundParams) throws Exception {
		return mainService.confirmRefund(refundParams);
	}

	/**
	 * 退款
	 * @param param
	 * @return
	 * @throws PayException 
	 */
	public ResponseParams<RefundResult> refund(RefundParams refundParams) throws PayException {
		return mainService.refund(refundParams);
	}
	
	/**
	 * 医保结算确认
	 * @param param
	 * @return
	 * @throws PayException 
	 */
	public ResponseParams<MedicalSettleResult> medicalSettle(MedicalSettleParams medicalSettleParams) throws PayException {
		return mainService.medicalSettle(medicalSettleParams);
	}
	
	/**
	 * 医保结算确认 查询
	 * @param param
	 * @return
	 * @throws PayException 
	 */
	public ResponseParams<MedicalSettleQueryResult> medicalSettleQuery(MedicalSettleQueryParams medicalSettleQueryParams) throws PayException {
		return mainService.medicalSettleQuery(medicalSettleQueryParams);
	}
	
	
	/**
	 * 充值关闭
	 * @param param
	 * @return
	 * @throws PayException 
	 */
	public ResponseParams<RechargeCloseResult> rechargeClose(RechargeCloseParams rechargeCloseParams) throws PayException {
		return mainService.rechargeClose(rechargeCloseParams);
	}
	



	/**
	 * 自助终端结账
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<SettleResult> settle(SettleParams param) throws PayException {
		return mainService.settle(param);
	}
	
	/**
	 * 查询门诊待扣费单据(明细)
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<QueryWaitPayResult> queryWaitPay(QueryWaitPayParams param) throws PayException {
		return mainService.queryWaitPay(param);
	}
	
	/**
	 * 市民健康系统人员信息查询
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<QueryHeaSysAccountResult> queryHeaSysAccount(QueryHeaSysAccountParams param) throws PayException {
		return mainService.queryHeaSysAccount(param);
	}
	
	/**
	 * 监护人信息查询
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<QueryGuarderResult> queryGuarder(QueryGuarderParam param) throws PayException {
		return mainService.queryGuarder(param);
	}
	
	/**
	 * 门诊预交金支付医疗押金
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<PayForegiftResult> payMedicalDeposit(PayForegiftParams param) throws PayException {
		return mainService.payMedicalDeposit(param);
	}
	

	/**
	 * 打印病历
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<PrintMediRecordResult> printMedicalRecord(PrintMediRecordParams param) throws PayException {
		return mainService.printMedicalRecord(param);
	}
	
	/**
	 * 打印病历
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<PrintMediRecordResult> printMediRecord(PrintMediRecordParams param) throws PayException {
		return mainService.printMediRecord(param);
	}
	
	/**
	 * 门诊预交金支付医疗押金
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<PayForegiftResult> payForegift(PayForegiftParams param) throws PayException {
		return mainService.payForegift(param);
	}

	/**
	 * 查询待扣费明细
	 * @param param
	 * @return
	 */
	public ResponseParams<QueryWaitVoucherResult> queryWaitVoucher(	QueryWaitVoucherParams param) throws PayException {
		return mainService.queryWaitVoucher(param);
	}
	/**
	 * 发送短信
	 * @param param
	 * @return
	 */
	public ResponseParams<SendSmsResult> sendSms(SendSmsParams param) throws PayException {
		return mainService.sendSms(param);
	}

	/**
	 * HOP移动医保结算
	 * @param param
	 * @return
	 * @throws PayException
	 */
	public ResponseParams<MMPayResult> mmpay(MMPayParam param) throws PayException {
		return mainService.mmpay(param);
	}

	/**
	 * 医保支付消息 推送
	 * @param param
	 * @return
	 * @throws PayException 
	 */
	public ResponseParams<MmpPushResult> mmpMsgPush(JSONObject param) throws PayException {
		return mainService.mmpMsgPush(param);
	}
}
