package com.ylzinfo.onepay.sdk.domain;

import java.io.Serializable;
import java.util.List;

import com.ylzinfo.onepay.sdk.enums.Channel;

public class QueryParams implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String termNo; // 交易终端编号
	/**
	 * 渠道类型，可查询多个渠道的流水
	 */
	List<Channel> channels;
	/**
	 * 订单号
	 */
	String chargeNo;
	/**
	 * 开始日期
	 */
	String startDate;
	/**
	 * 结束日期
	 */
	String endDate;
	/**
	 * 分页查询页码
	 */
	Integer pageNo;
	/**
	 * 分页查询每页的条数， 默认为10，最大为50。设置为10，表示只查询满足条件的10条数据
	 */
	Integer pageSize;
	
	/**
	 * 退款流水号，仅在查询退款流水的时候有用
	 */
	String refundNo;

	public List<Channel> getChannels() {
		return channels;
	}

	public void setChannels(List<Channel> channels) {
		this.channels = channels;
	}

	public String getChargeNo() {
		return chargeNo;
	}

	public void setChargeNo(String chargeNo) {
		this.chargeNo = chargeNo;
	}
	
	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public Integer getPageNo() {
		return pageNo;
	}

	public void setPageNo(Integer pageNo) {
		this.pageNo = pageNo;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public String getRefundNo() {
		return refundNo;
	}

	public void setRefundNo(String refundNo) {
		this.refundNo = refundNo;
	}

	public String getTermNo() {
		return termNo;
	}

	public void setTermNo(String termNo) {
		this.termNo = termNo;
	}
}
