/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class JpaSort
extends Sort {
    private static final long serialVersionUID = 1L;

    public JpaSort(Attribute<?, ?> ... attributes) {
        this(DEFAULT_DIRECTION, attributes);
    }

    public JpaSort(Path<?, ?> ... paths) {
        this(DEFAULT_DIRECTION, paths);
    }

    public JpaSort(Sort.Direction direction, Attribute<?, ?> ... attributes) {
        this(direction, JpaSort.paths(Arrays.asList(attributes)));
    }

    public JpaSort(Sort.Direction direction, Path<?, ?> ... paths) {
        this(direction, Arrays.asList(paths));
    }

    private JpaSort(Sort.Direction direction, List<Path<?, ?>> paths) {
        super(direction, JpaSort.toString(paths));
    }

    private static List<Path<?, ?>> paths(List<? extends Attribute<?, ?>> attributes) {
        Assert.notNull(attributes, (String)"Attributes must not be null!");
        Assert.isTrue((!attributes.isEmpty() ? 1 : 0) != 0, (String)"Attributes must not be empty");
        ArrayList paths = new ArrayList(attributes.size());
        for (Attribute<?, ?> attribute : attributes) {
            paths.add(JpaSort.path(attribute));
        }
        return paths;
    }

    private static String[] toString(List<Path<?, ?>> paths) {
        ArrayList<String> strings = new ArrayList<String>(paths.size());
        for (Path<?, ?> path : paths) {
            strings.add(path.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static <T, S> Path<T, S> path(Attribute<T, S> attribute) {
        Assert.notNull(attribute, (String)"Attribute must not be null!");
        List<Attribute> attributes = Arrays.asList(attribute);
        return new Path(attributes);
    }

    public static <T, S> Path<T, S> path(PluralAttribute<T, ?, S> attribute) {
        Assert.notNull(attribute, (String)"Attribute must not be null!");
        List<PluralAttribute> attributes = Arrays.asList(attribute);
        return new Path(attributes);
    }

    public static class Path<T, S> {
        private final Collection<Attribute<?, ?>> attributes;

        private Path(List<? extends Attribute<?, ?>> attributes) {
            this.attributes = Collections.unmodifiableList(attributes);
        }

        public <U> Path<S, U> dot(Attribute<S, U> attribute) {
            return new Path<T, S>(this.add(attribute));
        }

        public <U> Path<S, U> dot(PluralAttribute<S, ?, U> attribute) {
            return new Path<T, S>(this.add((Attribute<?, ?>)attribute));
        }

        private List<Attribute<?, ?>> add(Attribute<?, ?> attribute) {
            Assert.notNull(attribute, (String)"Attribute must not be null!");
            ArrayList newAttributes = new ArrayList(this.attributes.size() + 1);
            newAttributes.addAll(this.attributes);
            newAttributes.add(attribute);
            return newAttributes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Attribute<?, ?> attribute : this.attributes) {
                builder.append(attribute.getName()).append(".");
            }
            return builder.length() == 0 ? "" : builder.substring(0, builder.lastIndexOf("."));
        }
    }
}

