/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.ConfigurationPrinterHelper;
import org.thymeleaf.DialectConfiguration;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.doctype.DocTypeIdentifier;
import org.thymeleaf.doctype.resolution.IDocTypeResolutionEntry;
import org.thymeleaf.doctype.translation.IDocTypeTranslation;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableAttributeHolderNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.AlreadyInitializedException;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.NotInitializedException;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.processor.ProcessorAndContext;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.templatemode.ITemplateModeHandler;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    @Deprecated
    public static final IDialect STANDARD_THYMELEAF_DIALECT = new StandardDialect();
    private static final TemplateResolverComparator TEMPLATE_RESOLVER_COMPARATOR = new TemplateResolverComparator();
    private static final MessageResolverComparator MESSAGE_RESOLVER_COMPARATOR = new MessageResolverComparator();
    private Set<DialectConfiguration> dialectConfigurations = null;
    private Map<String, IDialect> dialectsByPrefix = null;
    private Set<IDialect> dialectSet = null;
    private Set<ITemplateResolver> templateResolvers = new LinkedHashSet<ITemplateResolver>(3);
    private Set<IMessageResolver> messageResolvers = new LinkedHashSet<IMessageResolver>(3);
    private Set<ITemplateModeHandler> templateModeHandlers = new LinkedHashSet<ITemplateModeHandler>(8);
    private ICacheManager cacheManager = null;
    private Map<String, Set<ProcessorAndContext>> mergedSpecificProcessorsByElementName;
    private Map<String, Set<ProcessorAndContext>> mergedSpecificProcessorsByAttributeName;
    private Map<Class<? extends Node>, Set<ProcessorAndContext>> mergedNonSpecificProcessorsByNodeClass;
    private Map<String, Object> mergedExecutionAttributes = null;
    private Set<IDocTypeResolutionEntry> mergedDocTypeResolutionEntries = null;
    private Set<IDocTypeTranslation> mergedDocTypeTranslations = null;
    private final Map<String, ITemplateModeHandler> templateModeHandlersByName = new HashMap<String, ITemplateModeHandler>(8, 1.0f);
    private Set<IMessageResolver> defaultMessageResolvers = null;
    private Set<ITemplateModeHandler> defaultTemplateModeHandlers = null;
    private volatile boolean initialized;

    public Configuration() {
        StandardDialect standardDialect = new StandardDialect();
        this.dialectConfigurations = new LinkedHashSet<DialectConfiguration>(4);
        this.dialectConfigurations.add(new DialectConfiguration(standardDialect.getPrefix(), standardDialect));
        this.initialized = false;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void checkNotInitialized() {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException("Cannot modify template engine configuration when it has already been initialized");
        }
    }

    private void checkInitialized() {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Configuration has not been initialized");
        }
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            if (this.dialectConfigurations == null) {
                throw new ConfigurationException("Cannot initialize: a dialect has not been set");
            }
            for (DialectConfiguration dialectConfiguration : this.dialectConfigurations) {
                dialectConfiguration.initialize();
            }
            this.dialectsByPrefix = new LinkedHashMap<String, IDialect>(4, 1.0f);
            for (DialectConfiguration dialectConfiguration : this.dialectConfigurations) {
                this.dialectsByPrefix.put(dialectConfiguration.getPrefix(), dialectConfiguration.getDialect());
            }
            this.dialectsByPrefix = Collections.unmodifiableMap(this.dialectsByPrefix);
            this.dialectSet = Collections.unmodifiableSet(new LinkedHashSet<IDialect>(this.dialectsByPrefix.values()));
            MergedDialectArtifacts mergedDialectArtifacts = Configuration.mergeDialects(this.dialectConfigurations);
            this.mergedSpecificProcessorsByElementName = Collections.unmodifiableMap(mergedDialectArtifacts.getSpecificProcessorsByElementName());
            this.mergedSpecificProcessorsByAttributeName = Collections.unmodifiableMap(mergedDialectArtifacts.getSpecificProcessorsByAttributeName());
            this.mergedNonSpecificProcessorsByNodeClass = Collections.unmodifiableMap(mergedDialectArtifacts.getMergedNonSpecificProcessorsByNodeClass());
            this.mergedExecutionAttributes = Collections.unmodifiableMap(mergedDialectArtifacts.getExecutionAttributes());
            this.mergedDocTypeResolutionEntries = Collections.unmodifiableSet(mergedDialectArtifacts.getDocTypeResolutionEntries());
            this.mergedDocTypeTranslations = Collections.unmodifiableSet(mergedDialectArtifacts.getDocTypeTranslations());
            if (this.templateResolvers == null || this.templateResolvers.size() <= 0) {
                throw new ConfigurationException("Cannot initialize: no template resolvers have been set");
            }
            ArrayList<ITemplateResolver> templateResolversList = new ArrayList<ITemplateResolver>(this.templateResolvers);
            for (ITemplateResolver templateResolver : templateResolversList) {
                templateResolver.initialize();
            }
            Collections.sort(templateResolversList, TEMPLATE_RESOLVER_COMPARATOR);
            this.templateResolvers = new LinkedHashSet<ITemplateResolver>(templateResolversList);
            if (this.messageResolvers == null) {
                throw new ConfigurationException("Cannot initialize: message resolvers set is null");
            }
            if (this.messageResolvers.size() == 0) {
                if (this.defaultMessageResolvers == null || this.defaultMessageResolvers.size() == 0) {
                    throw new ConfigurationException("Cannot initialize: no message resolvers have been set and no default message resolvers have been set either.");
                }
                this.messageResolvers = this.defaultMessageResolvers;
            }
            for (IMessageResolver messageResolver : this.messageResolvers) {
                messageResolver.initialize();
            }
            ArrayList<IMessageResolver> messageResolversList = new ArrayList<IMessageResolver>(this.messageResolvers);
            Collections.sort(messageResolversList, MESSAGE_RESOLVER_COMPARATOR);
            this.messageResolvers = new LinkedHashSet<IMessageResolver>(messageResolversList);
            if (this.templateModeHandlers == null) {
                throw new ConfigurationException("Cannot initialize: template mode handlers set is null");
            }
            if (this.templateModeHandlers.size() == 0) {
                if (this.defaultTemplateModeHandlers == null || this.defaultTemplateModeHandlers.size() == 0) {
                    throw new ConfigurationException("Cannot initialize: no template mode handlers have been set and no default template mode handlers have been set either.");
                }
                this.templateModeHandlers = this.defaultTemplateModeHandlers;
            }
            for (ITemplateModeHandler handler : this.templateModeHandlers) {
                if (this.templateModeHandlersByName.containsKey(handler.getTemplateModeName())) {
                    throw new ConfigurationException("More than one handler configured for template mode \"" + handler.getTemplateModeName() + "\"");
                }
                if (handler.getTemplateParser() == null) {
                    throw new ConfigurationException("Null parser returned by handler for template mode \"" + handler.getTemplateModeName() + "\"");
                }
                this.templateModeHandlersByName.put(handler.getTemplateModeName(), handler);
            }
            this.initialized = true;
        }
    }

    void printConfiguration() {
        ConfigurationPrinterHelper.printConfiguration(this.dialectConfigurations, this.templateResolvers, this.messageResolvers, this.cacheManager, this.templateModeHandlers);
    }

    public ICacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.checkNotInitialized();
        this.cacheManager = cacheManager;
    }

    public Set<IDialect> getDialectSet() {
        if (!this.isInitialized()) {
            return Collections.unmodifiableSet(new LinkedHashSet<IDialect>(this.getDialects().values()));
        }
        return this.dialectSet;
    }

    public Map<String, IDialect> getDialects() {
        if (!this.isInitialized()) {
            LinkedHashMap<String, IDialect> dialects = new LinkedHashMap<String, IDialect>(4, 1.0f);
            for (DialectConfiguration dialectConfiguration : this.dialectConfigurations) {
                dialects.put(dialectConfiguration.getPrefix(), dialectConfiguration.getDialect());
            }
            return Collections.unmodifiableMap(dialects);
        }
        return this.dialectsByPrefix;
    }

    public void setDialects(Map<String, IDialect> dialects) {
        this.checkNotInitialized();
        Validate.notNull(dialects, "Dialect set cannot be null");
        Validate.isTrue(dialects.size() > 0, "Dialect set cannot be empty");
        this.dialectConfigurations.clear();
        for (Map.Entry<String, IDialect> dialectEntry : dialects.entrySet()) {
            this.dialectConfigurations.add(new DialectConfiguration(dialectEntry.getKey(), dialectEntry.getValue()));
        }
    }

    public void setDialect(IDialect dialect) {
        this.checkNotInitialized();
        Validate.notNull(dialect, "Dialect set cannot be null");
        this.dialectConfigurations.clear();
        this.dialectConfigurations.add(new DialectConfiguration(dialect.getPrefix(), dialect));
    }

    public void addDialect(String prefix, IDialect dialect) {
        this.checkNotInitialized();
        Validate.notNull(dialect, "Dialect set cannot be null");
        this.dialectConfigurations.add(new DialectConfiguration(prefix, dialect));
    }

    public void clearDialects() {
        this.checkNotInitialized();
        this.dialectConfigurations.clear();
    }

    public Set<ITemplateResolver> getTemplateResolvers() {
        return Collections.unmodifiableSet(this.templateResolvers);
    }

    public void setTemplateResolvers(Set<? extends ITemplateResolver> templateResolvers) {
        this.checkNotInitialized();
        Validate.notNull(templateResolvers, "Template Resolver set cannot be null");
        Validate.isTrue(templateResolvers.size() > 0, "Template Resolver set cannot be empty");
        Validate.containsNoNulls(templateResolvers, "Template Resolver set cannot contain any nulls");
        this.templateResolvers = new LinkedHashSet<ITemplateResolver>(templateResolvers);
    }

    public void addTemplateResolver(ITemplateResolver templateResolver) {
        this.checkNotInitialized();
        Validate.notNull(templateResolver, "Template Resolver cannot be null");
        this.templateResolvers.add(templateResolver);
    }

    public void setTemplateResolver(ITemplateResolver templateResolver) {
        this.checkNotInitialized();
        Validate.notNull(templateResolver, "Template Resolver cannot be null");
        this.templateResolvers = Collections.singleton(templateResolver);
    }

    public Set<IMessageResolver> getMessageResolvers() {
        return Collections.unmodifiableSet(this.messageResolvers);
    }

    public void setMessageResolvers(Set<? extends IMessageResolver> messageResolvers) {
        this.checkNotInitialized();
        Validate.notNull(messageResolvers, "Message Resolver set cannot be null");
        Validate.isTrue(messageResolvers.size() > 0, "Message Resolver set cannot be empty");
        Validate.containsNoNulls(messageResolvers, "Message Resolver set cannot contain any nulls");
        this.messageResolvers = new LinkedHashSet<IMessageResolver>(messageResolvers);
    }

    public void addMessageResolver(IMessageResolver messageResolver) {
        this.checkNotInitialized();
        Validate.notNull(messageResolver, "Message Resolver cannot be null");
        this.messageResolvers.add(messageResolver);
    }

    public void setMessageResolver(IMessageResolver messageResolver) {
        this.checkNotInitialized();
        Validate.notNull(messageResolver, "Message Resolver cannot be null");
        this.messageResolvers = Collections.singleton(messageResolver);
    }

    public void setDefaultMessageResolvers(Set<? extends IMessageResolver> defaultMessageResolvers) {
        this.checkNotInitialized();
        Validate.notNull(defaultMessageResolvers, "Default Message Resolver set cannot be null");
        Validate.isTrue(defaultMessageResolvers.size() > 0, "Default Message Resolver set cannot be empty");
        Validate.containsNoNulls(defaultMessageResolvers, "Default Message Resolver set cannot contain any nulls");
        this.defaultMessageResolvers = new LinkedHashSet<IMessageResolver>(defaultMessageResolvers);
    }

    public Set<ITemplateModeHandler> getTemplateModeHandlers() {
        return Collections.unmodifiableSet(this.templateModeHandlers);
    }

    public ITemplateModeHandler getTemplateModeHandler(String templateMode) {
        return this.templateModeHandlersByName.get(templateMode);
    }

    public void setTemplateModeHandlers(Set<? extends ITemplateModeHandler> templateModeHandlers) {
        this.checkNotInitialized();
        Validate.notNull(templateModeHandlers, "Template Mode Handler set cannot be null");
        Validate.isTrue(templateModeHandlers.size() > 0, "Template Mode Handler set cannot be empty");
        Validate.containsNoNulls(templateModeHandlers, "Template Mode Handler set cannot contain any nulls");
        this.templateModeHandlers = new LinkedHashSet<ITemplateModeHandler>(templateModeHandlers);
    }

    public void addTemplateModeHandler(ITemplateModeHandler templateModeHandler) {
        this.checkNotInitialized();
        Validate.notNull(templateModeHandler, "Template Mode Handler cannot be null");
        this.templateModeHandlers.add(templateModeHandler);
    }

    public void setDefaultTemplateModeHandlers(Set<? extends ITemplateModeHandler> defaultTemplateModeHandlers) {
        this.checkNotInitialized();
        Validate.notNull(defaultTemplateModeHandlers, "Default Template Mode Handler set cannot be null");
        Validate.isTrue(defaultTemplateModeHandlers.size() > 0, "Default Template Mode Handler set cannot be empty");
        Validate.containsNoNulls(defaultTemplateModeHandlers, "Default Template Mode Handler set cannot contain any nulls");
        this.defaultTemplateModeHandlers = new LinkedHashSet<ITemplateModeHandler>(defaultTemplateModeHandlers);
    }

    public Set<IDocTypeTranslation> getDocTypeTranslations() {
        this.checkInitialized();
        return this.mergedDocTypeTranslations;
    }

    public IDocTypeTranslation getDocTypeTranslationBySource(String publicID, String systemID) {
        this.checkInitialized();
        for (IDocTypeTranslation translation : this.mergedDocTypeTranslations) {
            if (!translation.getSourcePublicID().matches(publicID) || !translation.getSourceSystemID().matches(systemID)) continue;
            return translation;
        }
        return null;
    }

    public Set<IDocTypeResolutionEntry> getDocTypeResolutionEntries() {
        this.checkInitialized();
        return this.mergedDocTypeResolutionEntries;
    }

    public ArrayList<ProcessorAndContext> computeProcessorsForNode(Node node) {
        if (node instanceof NestableAttributeHolderNode) {
            Element element;
            Set<ProcessorAndContext> processorsForElementName;
            ArrayList<ProcessorAndContext> processors = new ArrayList<ProcessorAndContext>(2);
            NestableAttributeHolderNode nestableNode = (NestableAttributeHolderNode)node;
            if (node instanceof Element && (processorsForElementName = this.mergedSpecificProcessorsByElementName.get((element = (Element)nestableNode).getNormalizedName())) != null) {
                for (ProcessorAndContext processorAndContext : processorsForElementName) {
                    if (!processorAndContext.matches(node)) continue;
                    processors.add(processorAndContext);
                }
            }
            String[] normalizedAttributeNames = nestableNode.unsafeGetAttributeNormalizedNames();
            int normalizedAttributesLen = nestableNode.numAttributes();
            for (int i = 0; i < normalizedAttributesLen; ++i) {
                String normalizedAttributeName = normalizedAttributeNames[i];
                Set<ProcessorAndContext> processorsForAttributeName = this.mergedSpecificProcessorsByAttributeName.get(normalizedAttributeName);
                if (processorsForAttributeName == null) continue;
                for (ProcessorAndContext processorAndContext : processorsForAttributeName) {
                    if (!processorAndContext.matches(node)) continue;
                    processors.add(processorAndContext);
                }
            }
            Set<ProcessorAndContext> applicableNonSpecificProcessors = this.getApplicableNonSpecificProcessorsToNodeClass(NestableAttributeHolderNode.class);
            if (applicableNonSpecificProcessors != null) {
                for (ProcessorAndContext processorAndContext : applicableNonSpecificProcessors) {
                    if (!processorAndContext.matches(node)) continue;
                    processors.add(processorAndContext);
                }
            }
            if (processors.size() > 1) {
                Collections.sort(processors);
            }
            return processors;
        }
        Set<ProcessorAndContext> applicableNonSpecificProcessors = this.getApplicableNonSpecificProcessorsToNodeClass(node.getClass());
        if (applicableNonSpecificProcessors != null) {
            ArrayList<ProcessorAndContext> processors = new ArrayList<ProcessorAndContext>(2);
            for (ProcessorAndContext processorAndContext : applicableNonSpecificProcessors) {
                if (!processorAndContext.matches(node)) continue;
                processors.add(processorAndContext);
            }
            Collections.sort(processors);
            return processors;
        }
        return null;
    }

    public Map<String, Object> getExecutionAttributes() {
        this.checkInitialized();
        return this.mergedExecutionAttributes;
    }

    public Set<String> getAllPrefixes() {
        this.checkInitialized();
        return this.dialectsByPrefix.keySet();
    }

    public boolean isPrefixManaged(String prefix) {
        return this.dialectsByPrefix.containsKey(prefix);
    }

    private Set<ProcessorAndContext> getApplicableNonSpecificProcessorsToNodeClass(Class<? extends Node> nodeClass) {
        HashSet result = null;
        for (Map.Entry<Class<? extends Node>, Set<ProcessorAndContext>> entry : this.mergedNonSpecificProcessorsByNodeClass.entrySet()) {
            Class<? extends Node> entryNodeClass = entry.getKey();
            if (!entryNodeClass.isAssignableFrom(nodeClass)) continue;
            if (result == null) {
                result = new HashSet(2);
            }
            result.addAll(entry.getValue());
        }
        return result;
    }

    private static MergedDialectArtifacts mergeDialects(Set<DialectConfiguration> dialectConfigurations) {
        if (dialectConfigurations == null || dialectConfigurations.isEmpty()) {
            throw new ConfigurationException("No dialect has been specified");
        }
        HashMap<String, Set<ProcessorAndContext>> specificProcessorsByElementName = new HashMap<String, Set<ProcessorAndContext>>(20);
        HashMap<String, Set<ProcessorAndContext>> specificProcessorsByAttributeName = new HashMap<String, Set<ProcessorAndContext>>(20);
        HashMap<Class<? extends Node>, Set<ProcessorAndContext>> nonSpecificProcessorsByNodeClass = new HashMap<Class<? extends Node>, Set<ProcessorAndContext>>(20);
        HashMap<String, Object> executionAttributes = new HashMap<String, Object>(20);
        HashSet<IDocTypeResolutionEntry> docTypeResolutionEntries = new HashSet<IDocTypeResolutionEntry>(20);
        HashSet<IDocTypeTranslation> docTypeTranslations = new HashSet<IDocTypeTranslation>(20);
        if (dialectConfigurations.size() == 1) {
            DialectConfiguration dialectConfiguration = dialectConfigurations.iterator().next();
            IDialect dialect = dialectConfiguration.getDialect();
            specificProcessorsByElementName.putAll(dialectConfiguration.unsafeGetSpecificProcessorsByElementName());
            specificProcessorsByAttributeName.putAll(dialectConfiguration.unsafeGetSpecificProcessorsByAttributeName());
            nonSpecificProcessorsByNodeClass.putAll(dialectConfiguration.unsafeGetNonSpecificProcessorsByNodeClass());
            executionAttributes.putAll(dialectConfiguration.getExecutionAttributes());
            docTypeResolutionEntries.addAll(dialect.getDocTypeResolutionEntries());
            docTypeTranslations.addAll(dialect.getDocTypeTranslations());
            return new MergedDialectArtifacts(specificProcessorsByElementName, specificProcessorsByAttributeName, nonSpecificProcessorsByNodeClass, executionAttributes, dialect.getDocTypeResolutionEntries(), dialect.getDocTypeTranslations());
        }
        HashSet mergedDialectClasses = new HashSet(5, 1.0f);
        for (DialectConfiguration dialectConfiguration : dialectConfigurations) {
            Map.Entry<Class<? extends Node>, Set<ProcessorAndContext>> processorsEntry2;
            IDialect dialect = dialectConfiguration.getDialect();
            if (mergedDialectClasses.contains(dialect.getClass())) {
                throw new ConfigurationException("Dialect is declared twice: " + dialect.getClass().getName());
            }
            specificProcessorsByElementName.putAll(dialectConfiguration.unsafeGetSpecificProcessorsByElementName());
            specificProcessorsByAttributeName.putAll(dialectConfiguration.unsafeGetSpecificProcessorsByAttributeName());
            for (Map.Entry<Class<? extends Node>, Set<ProcessorAndContext>> processorsEntry2 : dialectConfiguration.unsafeGetNonSpecificProcessorsByNodeClass().entrySet()) {
                Class<? extends Node> nodeClass = processorsEntry2.getKey();
                HashSet nonSpecificProcessorsByNodeClassValues = (HashSet)nonSpecificProcessorsByNodeClass.get(nodeClass);
                if (nonSpecificProcessorsByNodeClassValues == null) {
                    nonSpecificProcessorsByNodeClassValues = new HashSet(3);
                    nonSpecificProcessorsByNodeClass.put(nodeClass, nonSpecificProcessorsByNodeClassValues);
                }
                nonSpecificProcessorsByNodeClassValues.addAll((Collection)processorsEntry2.getValue());
            }
            executionAttributes.putAll(dialectConfiguration.getExecutionAttributes());
            Set<IDocTypeResolutionEntry> dialectDocTypeResolutionEntries = dialect.getDocTypeResolutionEntries();
            processorsEntry2 = dialectDocTypeResolutionEntries.iterator();
            while (processorsEntry2.hasNext()) {
                IDocTypeResolutionEntry dialectDocTypeResolutionEntry = (IDocTypeResolutionEntry)processorsEntry2.next();
                boolean addDialectDocTypeResolutionEntry = true;
                DocTypeIdentifier dialectDocTypeResolutionEntryPublicID = dialectDocTypeResolutionEntry.getPublicID();
                DocTypeIdentifier dialectDocTypeResolutionEntrySystemID = dialectDocTypeResolutionEntry.getSystemID();
                for (IDocTypeResolutionEntry docTypeResolutionEntry : docTypeResolutionEntries) {
                    boolean systemIDMatches;
                    boolean publicIDMatches;
                    DocTypeIdentifier docTypeResolutionEntryPublicID = docTypeResolutionEntry.getPublicID();
                    DocTypeIdentifier docTypeResolutionEntrySystemID = docTypeResolutionEntry.getSystemID();
                    if (dialectDocTypeResolutionEntryPublicID == null) {
                        publicIDMatches = docTypeResolutionEntryPublicID == null;
                    } else {
                        boolean bl = publicIDMatches = docTypeResolutionEntryPublicID != null && docTypeResolutionEntryPublicID.equals(dialectDocTypeResolutionEntryPublicID);
                    }
                    if (dialectDocTypeResolutionEntrySystemID == null) {
                        systemIDMatches = docTypeResolutionEntrySystemID == null;
                    } else {
                        boolean bl = systemIDMatches = docTypeResolutionEntrySystemID != null && docTypeResolutionEntrySystemID.equals(dialectDocTypeResolutionEntrySystemID);
                    }
                    if (!publicIDMatches || !systemIDMatches) continue;
                    if (!dialectDocTypeResolutionEntry.equals(docTypeResolutionEntry)) {
                        throw new ConfigurationException("Cannot initialize: two dialects provide different (non-equal) DOCTYPE resolution entries for PUBLICID \"" + docTypeResolutionEntryPublicID + "\" and SYSTEMID \"" + docTypeResolutionEntrySystemID + "\"");
                    }
                    addDialectDocTypeResolutionEntry = false;
                }
                if (!addDialectDocTypeResolutionEntry) continue;
                docTypeResolutionEntries.add(dialectDocTypeResolutionEntry);
            }
            Set<IDocTypeTranslation> dialectDocTypeTranslations = dialect.getDocTypeTranslations();
            for (IDocTypeTranslation dialectDocTypeTranslation : dialectDocTypeTranslations) {
                boolean addDialectDocTypeTranslation = true;
                DocTypeIdentifier dialectDocTypeTranslationSourcePublicID = dialectDocTypeTranslation.getSourcePublicID();
                DocTypeIdentifier dialectDocTypeTranslationSourceSystemID = dialectDocTypeTranslation.getSourceSystemID();
                DocTypeIdentifier dialectDocTypeTranslationTargetPublicID = dialectDocTypeTranslation.getTargetPublicID();
                DocTypeIdentifier dialectDocTypeTranslationTargetSystemID = dialectDocTypeTranslation.getTargetSystemID();
                for (IDocTypeTranslation docTypeTranslation : docTypeTranslations) {
                    boolean targetSystemIDMatches;
                    boolean targetPublicIDMatches;
                    DocTypeIdentifier docTypeTranslationSourcePublicID = docTypeTranslation.getSourcePublicID();
                    DocTypeIdentifier docTypeTranslationSourceSystemID = docTypeTranslation.getSourceSystemID();
                    DocTypeIdentifier docTypeTranslationTargetPublicID = docTypeTranslation.getTargetPublicID();
                    DocTypeIdentifier docTypeTranslationTargetSystemID = docTypeTranslation.getTargetSystemID();
                    boolean sourcePublicIDMatches = false;
                    boolean sourceSystemIDMatches = false;
                    if (dialectDocTypeTranslationSourcePublicID == null) {
                        sourcePublicIDMatches = docTypeTranslationSourcePublicID == null;
                    } else {
                        boolean bl = sourcePublicIDMatches = docTypeTranslationSourcePublicID != null && docTypeTranslationSourcePublicID.equals(dialectDocTypeTranslationSourcePublicID);
                    }
                    if (dialectDocTypeTranslationSourceSystemID == null) {
                        sourceSystemIDMatches = docTypeTranslationSourceSystemID == null;
                    } else {
                        boolean bl = sourceSystemIDMatches = docTypeTranslationSourceSystemID != null && docTypeTranslationSourceSystemID.equals(dialectDocTypeTranslationSourceSystemID);
                    }
                    if (!sourcePublicIDMatches || !sourceSystemIDMatches) continue;
                    if (dialectDocTypeTranslationTargetPublicID == null) {
                        targetPublicIDMatches = docTypeTranslationTargetPublicID == null;
                    } else {
                        boolean bl = targetPublicIDMatches = docTypeTranslationTargetPublicID != null && docTypeTranslationTargetPublicID.equals(dialectDocTypeTranslationTargetPublicID);
                    }
                    if (dialectDocTypeTranslationTargetSystemID == null) {
                        targetSystemIDMatches = docTypeTranslationTargetSystemID == null;
                    } else {
                        boolean bl = targetSystemIDMatches = docTypeTranslationTargetSystemID != null && docTypeTranslationTargetSystemID.equals(dialectDocTypeTranslationTargetSystemID);
                    }
                    if (!targetPublicIDMatches || !targetSystemIDMatches) {
                        throw new ConfigurationException("Cannot initialize: two dialects provide different (non-equal) DOCTYPE translations for PUBLICID \"" + docTypeTranslationSourcePublicID + "\" and SYSTEMID \"" + docTypeTranslationSourceSystemID + "\"");
                    }
                    addDialectDocTypeTranslation = false;
                }
                if (!addDialectDocTypeTranslation) continue;
                docTypeTranslations.add(dialectDocTypeTranslation);
            }
            mergedDialectClasses.add(dialect.getClass());
        }
        return new MergedDialectArtifacts(specificProcessorsByElementName, specificProcessorsByAttributeName, nonSpecificProcessorsByNodeClass, executionAttributes, docTypeResolutionEntries, docTypeTranslations);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageResolverComparator
    implements Comparator<IMessageResolver>,
    Serializable {
        private static final long serialVersionUID = 4700426328261944024L;

        MessageResolverComparator() {
        }

        @Override
        public int compare(IMessageResolver o1, IMessageResolver o2) {
            if (o1.getOrder() == null) {
                return -1;
            }
            if (o2.getOrder() == null) {
                return 1;
            }
            return o1.getOrder().compareTo(o2.getOrder());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TemplateResolverComparator
    implements Comparator<ITemplateResolver>,
    Serializable {
        private static final long serialVersionUID = -4959505530260386645L;

        TemplateResolverComparator() {
        }

        @Override
        public int compare(ITemplateResolver o1, ITemplateResolver o2) {
            if (o1.getOrder() == null) {
                return -1;
            }
            if (o2.getOrder() == null) {
                return 1;
            }
            return o1.getOrder().compareTo(o2.getOrder());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MergedDialectArtifacts {
        private final Map<String, Set<ProcessorAndContext>> specificProcessorsByElementName;
        private final Map<String, Set<ProcessorAndContext>> specificProcessorsByAttributeName;
        private final Map<Class<? extends Node>, Set<ProcessorAndContext>> nonSpecificProcessorsByNodeClass;
        private final Map<String, Object> executionAttributes;
        private final Set<IDocTypeResolutionEntry> docTypeResolutionEntries;
        private final Set<IDocTypeTranslation> docTypeTranslations;

        MergedDialectArtifacts(Map<String, Set<ProcessorAndContext>> specificProcessorsByElementName, Map<String, Set<ProcessorAndContext>> specificProcessorsByAttributeName, Map<Class<? extends Node>, Set<ProcessorAndContext>> nonSpecificProcessorsByNodeClass, Map<String, Object> executionAttributes, Set<IDocTypeResolutionEntry> docTypeResolutionEntries, Set<IDocTypeTranslation> docTypeTranslations) {
            this.specificProcessorsByElementName = specificProcessorsByElementName;
            this.specificProcessorsByAttributeName = specificProcessorsByAttributeName;
            this.nonSpecificProcessorsByNodeClass = nonSpecificProcessorsByNodeClass;
            this.executionAttributes = executionAttributes;
            this.docTypeResolutionEntries = docTypeResolutionEntries;
            this.docTypeTranslations = docTypeTranslations;
        }

        public Map<String, Set<ProcessorAndContext>> getSpecificProcessorsByElementName() {
            return this.specificProcessorsByElementName;
        }

        public Map<String, Set<ProcessorAndContext>> getSpecificProcessorsByAttributeName() {
            return this.specificProcessorsByAttributeName;
        }

        public Map<Class<? extends Node>, Set<ProcessorAndContext>> getMergedNonSpecificProcessorsByNodeClass() {
            return this.nonSpecificProcessorsByNodeClass;
        }

        public Map<String, Object> getExecutionAttributes() {
            return this.executionAttributes;
        }

        public Set<IDocTypeResolutionEntry> getDocTypeResolutionEntries() {
            return this.docTypeResolutionEntries;
        }

        public Set<IDocTypeTranslation> getDocTypeTranslations() {
            return this.docTypeTranslations;
        }
    }
}

