/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.cache;

import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.AbstractCacheManager;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheEntryValidityChecker;
import org.thymeleaf.cache.StandardCache;
import org.thymeleaf.cache.StandardParsedTemplateEntryValidator;
import org.thymeleaf.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardCacheManager
extends AbstractCacheManager {
    public static final String DEFAULT_TEMPLATE_CACHE_NAME = "TEMPLATE_CACHE";
    public static final int DEFAULT_TEMPLATE_CACHE_INITIAL_SIZE = 10;
    public static final int DEFAULT_TEMPLATE_CACHE_MAX_SIZE = 50;
    public static final boolean DEFAULT_TEMPLATE_CACHE_USE_SOFT_REFERENCES = true;
    public static final String DEFAULT_TEMPLATE_CACHE_LOGGER_NAME = null;
    public static final ICacheEntryValidityChecker<String, Template> DEFAULT_TEMPLATE_CACHE_VALIDITY_CHECKER = new StandardParsedTemplateEntryValidator();
    public static final String DEFAULT_FRAGMENT_CACHE_NAME = "FRAGMENT_CACHE";
    public static final int DEFAULT_FRAGMENT_CACHE_INITIAL_SIZE = 20;
    public static final int DEFAULT_FRAGMENT_CACHE_MAX_SIZE = 300;
    public static final boolean DEFAULT_FRAGMENT_CACHE_USE_SOFT_REFERENCES = true;
    public static final String DEFAULT_FRAGMENT_CACHE_LOGGER_NAME = null;
    public static final ICacheEntryValidityChecker<String, List<Node>> DEFAULT_FRAGMENT_CACHE_VALIDITY_CHECKER = null;
    public static final String DEFAULT_MESSAGE_CACHE_NAME = "MESSAGE_CACHE";
    public static final int DEFAULT_MESSAGE_CACHE_INITIAL_SIZE = 20;
    public static final int DEFAULT_MESSAGE_CACHE_MAX_SIZE = 300;
    public static final boolean DEFAULT_MESSAGE_CACHE_USE_SOFT_REFERENCES = true;
    public static final String DEFAULT_MESSAGE_CACHE_LOGGER_NAME = null;
    public static final ICacheEntryValidityChecker<String, Properties> DEFAULT_MESSAGE_CACHE_VALIDITY_CHECKER = null;
    public static final String DEFAULT_EXPRESSION_CACHE_NAME = "EXPRESSION_CACHE";
    public static final int DEFAULT_EXPRESSION_CACHE_INITIAL_SIZE = 100;
    public static final int DEFAULT_EXPRESSION_CACHE_MAX_SIZE = 500;
    public static final boolean DEFAULT_EXPRESSION_CACHE_USE_SOFT_REFERENCES = true;
    public static final String DEFAULT_EXPRESSION_CACHE_LOGGER_NAME = null;
    public static final ICacheEntryValidityChecker<String, Object> DEFAULT_EXPRESSION_CACHE_VALIDITY_CHECKER = null;
    private String templateCacheName = "TEMPLATE_CACHE";
    private int templateCacheInitialSize = 10;
    private int templateCacheMaxSize = 50;
    private boolean templateCacheUseSoftReferences = true;
    private String templateCacheLoggerName = DEFAULT_TEMPLATE_CACHE_LOGGER_NAME;
    private ICacheEntryValidityChecker<String, Template> templateCacheValidityChecker = DEFAULT_TEMPLATE_CACHE_VALIDITY_CHECKER;
    private String fragmentCacheName = "FRAGMENT_CACHE";
    private int fragmentCacheInitialSize = 20;
    private int fragmentCacheMaxSize = 300;
    private boolean fragmentCacheUseSoftReferences = true;
    private String fragmentCacheLoggerName = DEFAULT_FRAGMENT_CACHE_LOGGER_NAME;
    private ICacheEntryValidityChecker<String, List<Node>> fragmentCacheValidityChecker = DEFAULT_FRAGMENT_CACHE_VALIDITY_CHECKER;
    private String messageCacheName = "MESSAGE_CACHE";
    private int messageCacheInitialSize = 20;
    private int messageCacheMaxSize = 300;
    private boolean messageCacheUseSoftReferences = true;
    private String messageCacheLoggerName = DEFAULT_MESSAGE_CACHE_LOGGER_NAME;
    private ICacheEntryValidityChecker<String, Properties> messageCacheValidityChecker = DEFAULT_MESSAGE_CACHE_VALIDITY_CHECKER;
    private String expressionCacheName = "EXPRESSION_CACHE";
    private int expressionCacheInitialSize = 100;
    private int expressionCacheMaxSize = 500;
    private boolean expressionCacheUseSoftReferences = true;
    private String expressionCacheLoggerName = DEFAULT_EXPRESSION_CACHE_LOGGER_NAME;
    private ICacheEntryValidityChecker<String, Object> expressionCacheValidityChecker = DEFAULT_EXPRESSION_CACHE_VALIDITY_CHECKER;

    @Override
    protected final ICache<String, Template> initializeTemplateCache() {
        int maxSize = this.getTemplateCacheMaxSize();
        if (maxSize == 0) {
            return null;
        }
        return new StandardCache<String, Template>(this.getTemplateCacheName(), this.getTemplateCacheUseSoftReferences(), this.getTemplateCacheInitialSize(), maxSize, this.getTemplateCacheValidityChecker(), this.getTemplateCacheLogger());
    }

    @Override
    protected final ICache<String, List<Node>> initializeFragmentCache() {
        int maxSize = this.getFragmentCacheMaxSize();
        if (maxSize == 0) {
            return null;
        }
        return new StandardCache<String, List<Node>>(this.getFragmentCacheName(), this.getFragmentCacheUseSoftReferences(), this.getFragmentCacheInitialSize(), maxSize, this.getFragmentCacheValidityChecker(), this.getFragmentCacheLogger());
    }

    @Override
    protected final ICache<String, Properties> initializeMessageCache() {
        int maxSize = this.getMessageCacheMaxSize();
        if (maxSize == 0) {
            return null;
        }
        return new StandardCache<String, Properties>(this.getMessageCacheName(), this.getMessageCacheUseSoftReferences(), this.getMessageCacheInitialSize(), maxSize, this.getMessageCacheValidityChecker(), this.getMessageCacheLogger());
    }

    @Override
    protected final ICache<String, Object> initializeExpressionCache() {
        int maxSize = this.getExpressionCacheMaxSize();
        if (maxSize == 0) {
            return null;
        }
        return new StandardCache<String, Object>(this.getExpressionCacheName(), this.getExpressionCacheUseSoftReferences(), this.getExpressionCacheInitialSize(), maxSize, this.getExpressionCacheValidityChecker(), this.getExpressionCacheLogger());
    }

    public String getTemplateCacheName() {
        return this.templateCacheName;
    }

    public boolean getTemplateCacheUseSoftReferences() {
        return this.templateCacheUseSoftReferences;
    }

    public int getTemplateCacheInitialSize() {
        return this.templateCacheInitialSize;
    }

    public int getTemplateCacheMaxSize() {
        return this.templateCacheMaxSize;
    }

    public String getTemplateCacheLoggerName() {
        return this.templateCacheLoggerName;
    }

    public ICacheEntryValidityChecker<String, Template> getTemplateCacheValidityChecker() {
        return this.templateCacheValidityChecker;
    }

    public final Logger getTemplateCacheLogger() {
        String loggerName = this.getTemplateCacheLoggerName();
        if (loggerName != null) {
            return LoggerFactory.getLogger((String)loggerName);
        }
        return LoggerFactory.getLogger((String)(TemplateEngine.class.getName() + ".cache." + this.getTemplateCacheName()));
    }

    public String getFragmentCacheName() {
        return this.fragmentCacheName;
    }

    public boolean getFragmentCacheUseSoftReferences() {
        return this.fragmentCacheUseSoftReferences;
    }

    public int getFragmentCacheInitialSize() {
        return this.fragmentCacheInitialSize;
    }

    public int getFragmentCacheMaxSize() {
        return this.fragmentCacheMaxSize;
    }

    public String getFragmentCacheLoggerName() {
        return this.fragmentCacheLoggerName;
    }

    public ICacheEntryValidityChecker<String, List<Node>> getFragmentCacheValidityChecker() {
        return this.fragmentCacheValidityChecker;
    }

    public final Logger getFragmentCacheLogger() {
        String loggerName = this.getFragmentCacheLoggerName();
        if (loggerName != null) {
            return LoggerFactory.getLogger((String)loggerName);
        }
        return LoggerFactory.getLogger((String)(TemplateEngine.class.getName() + ".cache." + this.getFragmentCacheName()));
    }

    public String getMessageCacheName() {
        return this.messageCacheName;
    }

    public boolean getMessageCacheUseSoftReferences() {
        return this.messageCacheUseSoftReferences;
    }

    public int getMessageCacheInitialSize() {
        return this.messageCacheInitialSize;
    }

    public int getMessageCacheMaxSize() {
        return this.messageCacheMaxSize;
    }

    public String getMessageCacheLoggerName() {
        return this.messageCacheLoggerName;
    }

    public ICacheEntryValidityChecker<String, Properties> getMessageCacheValidityChecker() {
        return this.messageCacheValidityChecker;
    }

    public final Logger getMessageCacheLogger() {
        String loggerName = this.getMessageCacheLoggerName();
        if (loggerName != null) {
            return LoggerFactory.getLogger((String)loggerName);
        }
        return LoggerFactory.getLogger((String)(TemplateEngine.class.getName() + ".cache." + this.getMessageCacheName()));
    }

    public String getExpressionCacheName() {
        return this.expressionCacheName;
    }

    public boolean getExpressionCacheUseSoftReferences() {
        return this.expressionCacheUseSoftReferences;
    }

    public int getExpressionCacheInitialSize() {
        return this.expressionCacheInitialSize;
    }

    public int getExpressionCacheMaxSize() {
        return this.expressionCacheMaxSize;
    }

    public String getExpressionCacheLoggerName() {
        return this.expressionCacheLoggerName;
    }

    public ICacheEntryValidityChecker<String, Object> getExpressionCacheValidityChecker() {
        return this.expressionCacheValidityChecker;
    }

    public final Logger getExpressionCacheLogger() {
        String loggerName = this.getExpressionCacheLoggerName();
        if (loggerName != null) {
            return LoggerFactory.getLogger((String)loggerName);
        }
        return LoggerFactory.getLogger((String)(TemplateEngine.class.getName() + ".cache." + this.getExpressionCacheName()));
    }

    public void setTemplateCacheName(String templateCacheName) {
        this.templateCacheName = templateCacheName;
    }

    public void setTemplateCacheInitialSize(int templateCacheInitialSize) {
        this.templateCacheInitialSize = templateCacheInitialSize;
    }

    public void setTemplateCacheMaxSize(int templateCacheMaxSize) {
        this.templateCacheMaxSize = templateCacheMaxSize;
    }

    public void setTemplateCacheUseSoftReferences(boolean templateCacheUseSoftReferences) {
        this.templateCacheUseSoftReferences = templateCacheUseSoftReferences;
    }

    public void setTemplateCacheLoggerName(String templateCacheLoggerName) {
        this.templateCacheLoggerName = templateCacheLoggerName;
    }

    public void setTemplateCacheValidityChecker(ICacheEntryValidityChecker<String, Template> templateCacheValidityChecker) {
        this.templateCacheValidityChecker = templateCacheValidityChecker;
    }

    public void setFragmentCacheName(String fragmentCacheName) {
        this.fragmentCacheName = fragmentCacheName;
    }

    public void setFragmentCacheInitialSize(int fragmentCacheInitialSize) {
        this.fragmentCacheInitialSize = fragmentCacheInitialSize;
    }

    public void setFragmentCacheMaxSize(int fragmentCacheMaxSize) {
        this.fragmentCacheMaxSize = fragmentCacheMaxSize;
    }

    public void setFragmentCacheUseSoftReferences(boolean fragmentCacheUseSoftReferences) {
        this.fragmentCacheUseSoftReferences = fragmentCacheUseSoftReferences;
    }

    public void setFragmentCacheLoggerName(String fragmentCacheLoggerName) {
        this.fragmentCacheLoggerName = fragmentCacheLoggerName;
    }

    public void setFragmentCacheValidityChecker(ICacheEntryValidityChecker<String, List<Node>> fragmentCacheValidityChecker) {
        this.fragmentCacheValidityChecker = fragmentCacheValidityChecker;
    }

    public void setMessageCacheName(String messageCacheName) {
        this.messageCacheName = messageCacheName;
    }

    public void setMessageCacheInitialSize(int messageCacheInitialSize) {
        this.messageCacheInitialSize = messageCacheInitialSize;
    }

    public void setMessageCacheMaxSize(int messageCacheMaxSize) {
        this.messageCacheMaxSize = messageCacheMaxSize;
    }

    public void setMessageCacheUseSoftReferences(boolean messageCacheUseSoftReferences) {
        this.messageCacheUseSoftReferences = messageCacheUseSoftReferences;
    }

    public void setMessageCacheLoggerName(String messageCacheLoggerName) {
        this.messageCacheLoggerName = messageCacheLoggerName;
    }

    public void setMessageCacheValidityChecker(ICacheEntryValidityChecker<String, Properties> messageCacheValidityChecker) {
        this.messageCacheValidityChecker = messageCacheValidityChecker;
    }

    public void setExpressionCacheName(String expressionCacheName) {
        this.expressionCacheName = expressionCacheName;
    }

    public void setExpressionCacheInitialSize(int expressionCacheInitialSize) {
        this.expressionCacheInitialSize = expressionCacheInitialSize;
    }

    public void setExpressionCacheMaxSize(int expressionCacheMaxSize) {
        this.expressionCacheMaxSize = expressionCacheMaxSize;
    }

    public void setExpressionCacheUseSoftReferences(boolean expressionCacheUseSoftReferences) {
        this.expressionCacheUseSoftReferences = expressionCacheUseSoftReferences;
    }

    public void setExpressionCacheLoggerName(String expressionCacheLoggerName) {
        this.expressionCacheLoggerName = expressionCacheLoggerName;
    }

    public void setExpressionCacheValidityChecker(ICacheEntryValidityChecker<String, Object> expressionCacheValidityChecker) {
        this.expressionCacheValidityChecker = expressionCacheValidityChecker;
    }
}

