/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.DateUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Calendars {
    private final Locale locale;

    public Calendars(Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        this.locale = locale;
    }

    public Calendar create(Object year, Object month, Object day) {
        return DateUtils.create(year, month, day, null, null, null, null, null, this.locale);
    }

    public Calendar create(Object year, Object month, Object day, Object hour, Object minute) {
        return DateUtils.create(year, month, day, hour, minute, null, null, null, this.locale);
    }

    public Calendar create(Object year, Object month, Object day, Object hour, Object minute, Object second) {
        return DateUtils.create(year, month, day, hour, minute, second, null, null, this.locale);
    }

    public Calendar create(Object year, Object month, Object day, Object hour, Object minute, Object second, Object millisecond) {
        return DateUtils.create(year, month, day, hour, minute, second, millisecond, null, this.locale);
    }

    public Calendar createForTimeZone(Object year, Object month, Object day, Object timeZone) {
        return DateUtils.create(year, month, day, null, null, null, null, timeZone, this.locale);
    }

    public Calendar createForTimeZone(Object year, Object month, Object day, Object hour, Object minute, Object timeZone) {
        return DateUtils.create(year, month, day, hour, minute, null, null, timeZone, this.locale);
    }

    public Calendar createForTimeZone(Object year, Object month, Object day, Object hour, Object minute, Object second, Object timeZone) {
        return DateUtils.create(year, month, day, hour, minute, second, null, timeZone, this.locale);
    }

    public Calendar createForTimeZone(Object year, Object month, Object day, Object hour, Object minute, Object second, Object millisecond, Object timeZone) {
        return DateUtils.create(year, month, day, hour, minute, second, millisecond, timeZone, this.locale);
    }

    public Calendar createNow() {
        return DateUtils.createNow(null, this.locale);
    }

    public Calendar createNowForTimeZone(Object timeZone) {
        return DateUtils.createNow(timeZone, this.locale);
    }

    public Calendar createToday() {
        return DateUtils.createToday(null, this.locale);
    }

    public Calendar createTodayForTimeZone(Object timeZone) {
        return DateUtils.createToday(timeZone, this.locale);
    }

    public String format(Calendar target) {
        try {
            return DateUtils.format(target, this.locale);
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting calendar with standard format for locale " + this.locale, e);
        }
    }

    public String[] arrayFormat(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.format((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listFormat(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.format(calendar));
        }
        return result;
    }

    public Set<String> setFormat(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.format(calendar));
        }
        return result;
    }

    public String format(Calendar target, String pattern) {
        try {
            return DateUtils.format(target, pattern, this.locale);
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting calendar with format pattern \"" + pattern + "\"", e);
        }
    }

    public String[] arrayFormat(Object[] target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.format((Calendar)target[i], pattern);
        }
        return result;
    }

    public List<String> listFormat(List<? extends Calendar> target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.format(calendar, pattern));
        }
        return result;
    }

    public Set<String> setFormat(Set<? extends Calendar> target, String pattern) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.format(calendar, pattern));
        }
        return result;
    }

    public Integer day(Calendar target) {
        return DateUtils.day(target);
    }

    public Integer[] arrayDay(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.day((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listDay(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.day(calendar));
        }
        return result;
    }

    public Set<Integer> setDay(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.day(calendar));
        }
        return result;
    }

    public Integer month(Calendar target) {
        return DateUtils.month(target);
    }

    public Integer[] arrayMonth(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.month((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listMonth(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.month(calendar));
        }
        return result;
    }

    public Set<Integer> setMonth(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.month(calendar));
        }
        return result;
    }

    public String monthName(Calendar target) {
        return DateUtils.monthName(target, this.locale);
    }

    public String[] arrayMonthName(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.monthName((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listMonthName(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.monthName(calendar));
        }
        return result;
    }

    public Set<String> setMonthName(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.monthName(calendar));
        }
        return result;
    }

    public String monthNameShort(Calendar target) {
        return DateUtils.monthNameShort(target, this.locale);
    }

    public String[] arrayMonthNameShort(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.monthNameShort((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listMonthNameShort(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.monthNameShort(calendar));
        }
        return result;
    }

    public Set<String> setMonthNameShort(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.monthNameShort(calendar));
        }
        return result;
    }

    public Integer year(Calendar target) {
        return DateUtils.year(target);
    }

    public Integer[] arrayYear(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.year((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listYear(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.year(calendar));
        }
        return result;
    }

    public Set<Integer> setYear(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.year(calendar));
        }
        return result;
    }

    public Integer dayOfWeek(Calendar target) {
        return DateUtils.dayOfWeek(target);
    }

    public Integer[] arrayDayOfWeek(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeek((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listDayOfWeek(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.dayOfWeek(calendar));
        }
        return result;
    }

    public Set<Integer> setDayOfWeek(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.dayOfWeek(calendar));
        }
        return result;
    }

    public String dayOfWeekName(Calendar target) {
        return DateUtils.dayOfWeekName(target, this.locale);
    }

    public String[] arrayDayOfWeekName(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeekName((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listDayOfWeekName(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.dayOfWeekName(calendar));
        }
        return result;
    }

    public Set<String> setDayOfWeekName(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.dayOfWeekName(calendar));
        }
        return result;
    }

    public String dayOfWeekNameShort(Calendar target) {
        return DateUtils.dayOfWeekNameShort(target, this.locale);
    }

    public String[] arrayDayOfWeekNameShort(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.dayOfWeekNameShort((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listDayOfWeekNameShort(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.dayOfWeekNameShort(calendar));
        }
        return result;
    }

    public Set<String> setDayOfWeekNameShort(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.dayOfWeekNameShort(calendar));
        }
        return result;
    }

    public Integer hour(Calendar target) {
        return DateUtils.hour(target);
    }

    public Integer[] arrayHour(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.hour((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listHour(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.hour(calendar));
        }
        return result;
    }

    public Set<Integer> setHour(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.hour(calendar));
        }
        return result;
    }

    public Integer minute(Calendar target) {
        return DateUtils.minute(target);
    }

    public Integer[] arrayMinute(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.minute((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listMinute(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.minute(calendar));
        }
        return result;
    }

    public Set<Integer> setMinute(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.minute(calendar));
        }
        return result;
    }

    public Integer second(Calendar target) {
        return DateUtils.second(target);
    }

    public Integer[] arraySecond(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.second((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listSecond(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.second(calendar));
        }
        return result;
    }

    public Set<Integer> setSecond(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.second(calendar));
        }
        return result;
    }

    public Integer millisecond(Calendar target) {
        return DateUtils.millisecond(target);
    }

    public Integer[] arrayMillisecond(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.millisecond((Calendar)target[i]);
        }
        return result;
    }

    public List<Integer> listMillisecond(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.millisecond(calendar));
        }
        return result;
    }

    public Set<Integer> setMillisecond(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.millisecond(calendar));
        }
        return result;
    }

    public String formatISO(Calendar target) {
        try {
            return DateUtils.formatISO(target);
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error formatting calendar as ISO8601", e);
        }
    }

    public String[] arrayFormatISO(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.formatISO((Calendar)target[i]);
        }
        return result;
    }

    public List<String> listFormatISO(List<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.formatISO(calendar));
        }
        return result;
    }

    public Set<String> setFormatISO(Set<? extends Calendar> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>(target.size() + 2);
        for (Calendar calendar : target) {
            result.add(this.formatISO(calendar));
        }
        return result;
    }
}

