/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.util.Validate;

public final class TextLiteralExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(TextLiteralExpression.class);
    private static final long serialVersionUID = 6511847028638506552L;
    static final char DELIMITER = '\'';
    private static final Pattern DELIMITER_ESCAPE_PATTERN = Pattern.compile("\\\\'");
    private final LiteralValue value;

    public TextLiteralExpression(String value) {
        Validate.notNull(value, "Value cannot be null");
        this.value = new LiteralValue(TextLiteralExpression.unwrapLiteral(value));
    }

    public LiteralValue getValue() {
        return this.value;
    }

    private static String unwrapLiteral(String input) {
        int inputLen = input.length();
        if (inputLen > 1 && input.charAt(0) == '\'' && input.charAt(inputLen - 1) == '\'') {
            String unwrappedInput = input.substring(1, inputLen - 1);
            return DELIMITER_ESCAPE_PATTERN.matcher(unwrappedInput).replaceAll("'");
        }
        return input;
    }

    public String getStringRepresentation() {
        return String.valueOf('\'') + this.value.getValue().replace(String.valueOf('\''), "\\'") + String.valueOf('\'');
    }

    static TextLiteralExpression parseTextLiteral(String input) {
        return new TextLiteralExpression(input);
    }

    static Object executeTextLiteral(IProcessingContext processingContext, TextLiteralExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating text literal: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }

    public static String wrapStringIntoLiteral(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder strBuilder = new StringBuilder(str.length() + 5);
        strBuilder.append('\'');
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (c == '\'') {
                strBuilder.append('\\');
            }
            strBuilder.append(c);
        }
        strBuilder.append('\'');
        return strBuilder.toString();
    }

    static boolean isDelimiterEscaped(String input, int pos) {
        if (pos == 0 || input.charAt(pos - 1) != '\\') {
            return false;
        }
        boolean odd = false;
        for (int i = pos - 1; i >= 0; --i) {
            if (input.charAt(i) != '\\') {
                return odd;
            }
            odd = !odd;
        }
        return odd;
    }
}

