/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.fragment;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.thymeleaf.Configuration;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.fragment.StandardFragmentSignatureNodeReferenceChecker;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardDOMSelectorFragmentSpec
implements IFragmentSpec {
    private static final ConcurrentHashMap<Configuration, DOMSelector.INodeReferenceChecker> REFERENCE_CHECKERS_BY_CONFIGURATION = new ConcurrentHashMap(3);
    private final String selectorExpression;
    private final String domSelectorCacheKey;

    public StandardDOMSelectorFragmentSpec(String selectorExpression) {
        Validate.notEmpty(selectorExpression, "DOM selector expression cannot be null or empty");
        this.selectorExpression = selectorExpression;
        this.domSelectorCacheKey = StandardDOMSelectorFragmentSpec.generateDOMSelectorCacheKey(this.selectorExpression);
    }

    public String getSelectorExpression() {
        return this.selectorExpression;
    }

    @Override
    public final List<Node> extractFragment(Configuration configuration, List<Node> nodes) {
        DOMSelector.INodeReferenceChecker referenceChecker;
        List<Node> extraction;
        DOMSelector selector = null;
        ICache<String, Object> expressionCache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (expressionCache = cacheManager.getExpressionCache()) != null) {
            selector = (DOMSelector)expressionCache.get(this.domSelectorCacheKey);
        }
        if (selector == null) {
            selector = new DOMSelector(this.selectorExpression);
            if (expressionCache != null) {
                expressionCache.put(this.domSelectorCacheKey, selector);
            }
        }
        if ((extraction = selector.select(nodes, referenceChecker = StandardDOMSelectorFragmentSpec.getReferenceChecker(configuration))) == null || extraction.size() == 0) {
            return null;
        }
        return extraction;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("(STANDARDDOMSELECTOR: ");
        strBuilder.append(this.selectorExpression);
        strBuilder.append(")");
        return strBuilder.toString();
    }

    private static String generateDOMSelectorCacheKey(String selectorExpression) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("{dom_selector}");
        strBuilder.append(selectorExpression);
        return strBuilder.toString();
    }

    private static DOMSelector.INodeReferenceChecker getReferenceChecker(Configuration configuration) {
        DOMSelector.INodeReferenceChecker referenceChecker = REFERENCE_CHECKERS_BY_CONFIGURATION.get(configuration);
        if (referenceChecker != null) {
            return referenceChecker;
        }
        String dialectPrefix = StandardDOMSelectorFragmentSpec.getStandardDialectPrefix(configuration);
        StandardFragmentSignatureNodeReferenceChecker newReferenceChecker = new StandardFragmentSignatureNodeReferenceChecker(configuration, dialectPrefix, "fragment");
        REFERENCE_CHECKERS_BY_CONFIGURATION.put(configuration, newReferenceChecker);
        return newReferenceChecker;
    }

    private static String getStandardDialectPrefix(Configuration configuration) {
        for (Map.Entry<String, IDialect> dialectByPrefix : configuration.getDialects().entrySet()) {
            IDialect dialect = dialectByPrefix.getValue();
            if (!StandardDialect.class.isAssignableFrom(dialect.getClass())) continue;
            return dialectByPrefix.getKey();
        }
        throw new ConfigurationException("A Thymeleaf Standard Dialect has not been found in the current configuration, but it is required in order to use " + StandardDOMSelectorFragmentSpec.class.getName());
    }
}

