/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateAssertionException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractAssertionAttrProcessor;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.ExpressionSequenceUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.util.EvaluationUtil;
import org.thymeleaf.util.StringUtils;

public abstract class AbstractStandardAssertionAttrProcessor
extends AbstractAssertionAttrProcessor {
    protected AbstractStandardAssertionAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractStandardAssertionAttrProcessor(String attributeName) {
        super(attributeName);
    }

    protected final void checkAssertions(Arguments arguments, Element element, String attributeName, String attributeValue) {
        if (StringUtils.isEmptyOrWhitespace(attributeValue)) {
            return;
        }
        Configuration configuration = arguments.getConfiguration();
        ExpressionSequence expressionSequence = ExpressionSequenceUtils.parseExpressionSequence(configuration, arguments, attributeValue);
        List<IStandardExpression> expressions = expressionSequence.getExpressions();
        for (IStandardExpression expression : expressions) {
            Object expressionResult = expression.execute(arguments.getConfiguration(), arguments);
            boolean expressionBooleanResult = EvaluationUtil.evaluateAsBoolean(expressionResult);
            if (expressionBooleanResult) continue;
            throw new TemplateAssertionException(expression.getStringRepresentation(), arguments.getTemplateName(), element.getLineNumber());
        }
    }
}

