package com.ylzinfo.onepay.sdk.domain;

import java.io.Serializable;
import java.util.Map;

/**
 * @Title: RefundParams.java
 * @Description: 退款请求参数
 * @Author: zwsun @Date 2015年9月29日
 * @version V1.0
 */
public class RefundParams implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String termNo; // 交易终端编号

	/**
	 * 订单号
	 */
	String outChargeNo;

	/**
	 * 退款流水号
	 */
	String outRefundNo;

	/**
	 * 退款金额， 只能为整数，单位为分，例如 1
	 */
	Integer refundAmt;

	/**
	 * 附加数据， 用户自定义的参数，将会回调中原样返回，该字段主要用于商户携带订单的自定义数据
	 */
	Map<String, String> optional;

	private String refundReason;

	/**
	 * 操作员编号
	 */
	private String operatorId;

	/**
	 * 操作员姓名
	 */
	private String operatorName;
	/**扩展入参*/
	private Map<String, String> extra;

	public String getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}

	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public String getOutChargeNo() {
		return outChargeNo;
	}

	public void setOutChargeNo(String outChargeNo) {
		this.outChargeNo = outChargeNo;
	}

	public String getOutRefundNo() {
		return outRefundNo;
	}

	public void setOutRefundNo(String outRefundNo) {
		this.outRefundNo = outRefundNo;
	}

	public Integer getRefundAmt() {
		return refundAmt;
	}

	public void setRefundAmt(Integer refundAmt) {
		this.refundAmt = refundAmt;
	}

	public Map<String, String> getOptional() {
		return optional;
	}

	public void setOptional(Map<String, String> optional) {
		this.optional = optional;
	}

	public String getRefundReason() {
		return refundReason;
	}

	public void setRefundReason(String refundReason) {
		this.refundReason = refundReason;
	}

	public String getTermNo() {
		return termNo;
	}

	public Map<String, String> getExtra() {
		return extra;
	}

	public void setExtra(Map<String, String> extra) {
		this.extra = extra;
	}

	public void setTermNo(String termNo) {
		this.termNo = termNo;
	}

}
