package com.ylzinfo.onepay.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.ylzinfo.onepay.sdk.domain.ResponseParams;
import com.ylzinfo.onepay.sdk.domain.ext.AccountQueryParams;
import com.ylzinfo.onepay.sdk.domain.ext.AccountQueryResult;
import com.ylzinfo.onepay.sdk.domain.ext.CardCheckParams;
import com.ylzinfo.onepay.sdk.domain.ext.CardCheckResult;
import com.ylzinfo.onepay.sdk.domain.ext.ConsumeCancelParams;
import com.ylzinfo.onepay.sdk.domain.ext.ConsumeCancelResult;
import com.ylzinfo.onepay.sdk.domain.ext.ConsumeParams;
import com.ylzinfo.onepay.sdk.domain.ext.ConsumeResult;
import com.ylzinfo.onepay.sdk.domain.ext.GetPutFileFeeParams;
import com.ylzinfo.onepay.sdk.domain.ext.GetPutFileFeeResult;
import com.ylzinfo.onepay.sdk.domain.ext.GetPutFileInfoParams;
import com.ylzinfo.onepay.sdk.domain.ext.GetPutFileInfoResult;
import com.ylzinfo.onepay.sdk.domain.ext.MMPayParam;
import com.ylzinfo.onepay.sdk.domain.ext.MMPayResult;
import com.ylzinfo.onepay.sdk.domain.ext.MedicalSettleParams;
import com.ylzinfo.onepay.sdk.domain.ext.MedicalSettleQueryParams;
import com.ylzinfo.onepay.sdk.domain.ext.MedicalSettleQueryResult;
import com.ylzinfo.onepay.sdk.domain.ext.MedicalSettleResult;
import com.ylzinfo.onepay.sdk.domain.ext.MmpPushResult;
import com.ylzinfo.onepay.sdk.domain.ext.OpenAccountParams;
import com.ylzinfo.onepay.sdk.domain.ext.OpenAccountResult;
import com.ylzinfo.onepay.sdk.domain.ext.PayForegiftParams;
import com.ylzinfo.onepay.sdk.domain.ext.PayForegiftResult;
import com.ylzinfo.onepay.sdk.domain.ext.PrepareRefundParams;
import com.ylzinfo.onepay.sdk.domain.ext.PrepareRefundResult;
import com.ylzinfo.onepay.sdk.domain.ext.PrintMediRecordParams;
import com.ylzinfo.onepay.sdk.domain.ext.PrintMediRecordResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryBalanceParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryBalanceResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryDetailParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryDetailResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryGuarderParam;
import com.ylzinfo.onepay.sdk.domain.ext.QueryGuarderResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryHeaSysAccountParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryHeaSysAccountResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryWaitPayParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryWaitPayResult;
import com.ylzinfo.onepay.sdk.domain.ext.QueryWaitVoucherParams;
import com.ylzinfo.onepay.sdk.domain.ext.QueryWaitVoucherResult;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeCloseParams;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeCloseResult;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeConsumeCancelParams;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeConsumeCancelResult;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeConsumeParams;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeConsumeResult;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeParams;
import com.ylzinfo.onepay.sdk.domain.ext.RechargeResult;
import com.ylzinfo.onepay.sdk.domain.ext.RefundConfirmParams;
import com.ylzinfo.onepay.sdk.domain.ext.RefundConfirmResult;
import com.ylzinfo.onepay.sdk.domain.ext.RefundParams;
import com.ylzinfo.onepay.sdk.domain.ext.RefundResult;
import com.ylzinfo.onepay.sdk.domain.ext.RegisterTermParams;
import com.ylzinfo.onepay.sdk.domain.ext.RegisterTermResult;
import com.ylzinfo.onepay.sdk.domain.ext.SendSmsParams;
import com.ylzinfo.onepay.sdk.domain.ext.SendSmsResult;
import com.ylzinfo.onepay.sdk.domain.ext.SettleParams;
import com.ylzinfo.onepay.sdk.domain.ext.SettleResult;
import com.ylzinfo.onepay.sdk.domain.ext.TestCallParams;
import com.ylzinfo.onepay.sdk.domain.ext.TestCallResult;
import com.ylzinfo.onepay.sdk.domain.ext.TradeQueryParams;
import com.ylzinfo.onepay.sdk.domain.ext.TradeQueryResult;
import com.ylzinfo.onepay.sdk.domain.ext.WaitPayMainVO;
import com.ylzinfo.onepay.sdk.enums.TransType;
import com.ylzinfo.onepay.sdk.exception.PayException;

public class HisOnepayService extends MainService {

	/**
	 * 医院支付平台SDK入口
	 * 
	 * @param onepayUrl
	 *            支付平台服务地址
	 * @param appId
	 *            应用编号
	 * @param appSecret
	 *            应用密钥
	 */
	public HisOnepayService(String onepayUrl, String appId, String appSecret, String signType, String encryptType) {
		super(onepayUrl, appId, appSecret, signType, encryptType);
	}

	/**
	 * 医院支付平台SDK入口
	 * 
	 * @param appId
	 *            应用编号
	 * @param appSecret
	 *            应用密钥
	 */
	public HisOnepayService(String appId, String appSecret, String signType, String encryptType) {
		super(appId, appSecret, signType, encryptType);
	}

	public ResponseParams<RechargeResult> recharge(RechargeParams rechargeParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_RECHARGE.getCode();
		return doBusiness(transType, rechargeParams, RechargeResult.class);
	}

	public ResponseParams<ConsumeResult> consume(ConsumeParams consumeParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_PAY.getCode();
		return doBusiness(transType, consumeParams, ConsumeResult.class);
	}

	public ResponseParams<ConsumeCancelResult> consumeCancel(ConsumeCancelParams consumeCancelParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_PAY_CANCEL.getCode();
		return doBusiness(transType, consumeCancelParams, ConsumeCancelResult.class);
	}

	public ResponseParams<RechargeConsumeResult> rechargeConsume(RechargeConsumeParams rechargeConsumeParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_RECPAY.getCode();
		return doBusiness(transType, rechargeConsumeParams, RechargeConsumeResult.class);
	}

	public ResponseParams<RechargeConsumeCancelResult> rechargeConsumeCancel(RechargeConsumeCancelParams rechargeConsumeCancelParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_RECPAY_CANCEL.getCode();
		return doBusiness(transType, rechargeConsumeCancelParams, RechargeConsumeCancelResult.class);
	}

	public ResponseParams<AccountQueryResult> accountInfo(AccountQueryParams accountQueryParams) throws PayException {
		String transType = TransType.EXT_HOP_ACCOUNT_INFO.getCode();
		return doBusiness(transType, accountQueryParams, AccountQueryResult.class);
	}

	public ResponseParams<TradeQueryResult> tradeQuery(TradeQueryParams tradeQueryParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_QUERY.getCode();
		return doBusiness(transType, tradeQueryParams, TradeQueryResult.class);
	}

	public ResponseParams<QueryDetailResult> queryDetail(QueryDetailParams queryDetailParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_DETAILS.getCode();
		return doBusiness(transType, queryDetailParams, QueryDetailResult.class);
	}

	public ResponseParams<CardCheckResult> cardCheck(CardCheckParams param) throws PayException {
		String transType = TransType.EXT_HOP_CARD_CHECK.getCode();
		return doBusiness(transType, param, CardCheckResult.class);
	}

	public ResponseParams<GetPutFileFeeResult> getPutFileFee(GetPutFileFeeParams param) throws PayException {
		String transType = TransType.EXT_HOP_FILE_FEE.getCode();
		return doBusiness(transType, param, GetPutFileFeeResult.class);
	}

	public ResponseParams<GetPutFileInfoResult> getPutFileInfo(GetPutFileInfoParams param) throws PayException {
		String transType = TransType.EXT_HOP_FILE_INFO.getCode();
		return doBusiness(transType, param, GetPutFileInfoResult.class);
	}

	public ResponseParams<QueryBalanceResult> queryBalance(QueryBalanceParams param) throws PayException {
		String transType = TransType.EXT_HOP_QUERY_BALANCE.getCode();
		return doBusiness(transType, param, QueryBalanceResult.class);
	}

	public ResponseParams<TestCallResult> testCall(TestCallParams params) throws PayException {
		String transType = TransType.EXT_HOP_TEST_CALL.getCode();
		return doBusiness(transType, params, TestCallResult.class);
	}

	public ResponseParams<RegisterTermResult> registerTerm(RegisterTermParams params) throws PayException {
		String transType = TransType.EXT_HOP_REGISTER_TERM.getCode();
		return doBusiness(transType, params, RegisterTermResult.class);
	}

	public ResponseParams<OpenAccountResult> openAccount(OpenAccountParams params) throws PayException {
		String transType = TransType.EXT_HOP_ACCOUNT_OPEN.getCode();
		return doBusiness(transType, params, OpenAccountResult.class);
	}

	public ResponseParams<PrepareRefundResult> prepareRefund(PrepareRefundParams params) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_PREPARE_REFUND.getCode();
		return doBusiness(transType, params, PrepareRefundResult.class);
	}

	public ResponseParams<RefundConfirmResult> confirmRefund(RefundConfirmParams refundParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_CONFIRM_REFUND.getCode();
		return doBusiness(transType, refundParams, RefundConfirmResult.class);
	}

	public ResponseParams<RefundResult> refund(RefundParams refundParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_REFUND.getCode();
		return doBusiness(transType, refundParams, RefundResult.class);
	}

	public ResponseParams<MedicalSettleResult> medicalSettle(
			MedicalSettleParams medicalSettleParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_MEDICAL_SETTLE.getCode();
		return doBusiness(transType, medicalSettleParams, MedicalSettleResult.class);
	}

	public ResponseParams<MedicalSettleQueryResult> medicalSettleQuery(
			MedicalSettleQueryParams medicalSettleQueryParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_MEDICAL_SETTLE_QUERY.getCode();
		return doBusiness(transType, medicalSettleQueryParams, MedicalSettleQueryResult.class);
	}

	public ResponseParams<RechargeCloseResult> rechargeClose(
			RechargeCloseParams rechargeCloseParams) throws PayException {
		String transType = TransType.EXT_HOP_TRADE_RECHARGE_CLOSE.getCode();
		return doBusiness(transType, rechargeCloseParams, RechargeCloseResult.class);
	}


	public ResponseParams<SettleResult> settle(SettleParams param) throws PayException {
		String transType = TransType.EXT_HOP_MANAGE_SETTLE.getCode();
		return doBusiness(transType,param , SettleResult.class);
	}

	public ResponseParams<QueryWaitPayResult> queryWaitPay(	QueryWaitPayParams param) throws PayException {
		String transType = TransType.EXT_HOP_QUERY_WAIT_PAY.getCode();
		return doBusiness(transType,param , QueryWaitPayResult.class);
	}

	public ResponseParams<QueryHeaSysAccountResult> queryHeaSysAccount(	QueryHeaSysAccountParams param)throws PayException {
		String transType = TransType.EXT_HOP_QUERY_HEA_SYS_ACCOUNT.getCode();
		return doBusiness(transType,param , QueryHeaSysAccountResult.class);
	}

	public ResponseParams<QueryGuarderResult> queryGuarder(	QueryGuarderParam param) throws PayException {
		String transType = TransType.EXT_HOP_QUERY_GUARDER.getCode();
		return doBusiness(transType,param , QueryGuarderResult.class);
	}
	
	public ResponseParams<PayForegiftResult> payMedicalDeposit(PayForegiftParams param) throws PayException {
		String transType = TransType.EXT_HOP_PAY_MEDICAL_DEPOSIT.getCode();
		return doBusiness(transType,param , PayForegiftResult.class);
	}
	
	public ResponseParams<PrintMediRecordResult> printMedicalRecord(PrintMediRecordParams param) throws PayException {
		String transType = TransType.EXT_HOP_PRINT_MEDICAL_RECORD.getCode();
		return doBusiness(transType,param , PrintMediRecordResult.class);
	}

	public ResponseParams<PrintMediRecordResult> printMediRecord(PrintMediRecordParams param) throws PayException  {
		String transType = TransType.EXT_HOP_PRINT_MEDICAL_RECORD.getCode();
		return doBusiness(transType,param , PrintMediRecordResult.class);
	}

	public ResponseParams<PayForegiftResult> payForegift(PayForegiftParams param) throws PayException  {
		String transType = TransType.EXT_HOP_PAY_MEDICAL_DEPOSIT.getCode();
		return doBusiness(transType,param , PayForegiftResult.class);
	}

	public ResponseParams<QueryWaitVoucherResult> queryWaitVoucher  (QueryWaitVoucherParams param)throws PayException {
		String transType = TransType.EXT_HOP_QUERY_WAIT_VOUCHER.getCode();
		return doBusiness(transType,param , QueryWaitVoucherResult.class);
	}
	public ResponseParams<SendSmsResult> sendSms(SendSmsParams param)throws PayException {
		String transType = TransType.EXT_HOP_SEND_SMS.getCode();
		return doBusiness(transType,param , SendSmsResult.class);
	}

	public ResponseParams<MMPayResult> mmpay(MMPayParam param) throws PayException{
		String transType = TransType.EXT_HOP_TRADE_MMPAY.getCode();
		return doBusiness(transType,param , MMPayResult.class);
	}

	public ResponseParams<MmpPushResult> mmpMsgPush(JSONObject param) throws PayException {
		String transType = TransType.EXT_HOP_MMPAY_MSG_PUSH.getCode();
		return doBusiness(transType,param , MmpPushResult.class);
	}
}
