package com.ylzinfo.onepay.sdk.utils;

import java.math.BigDecimal;

public class PayUtils {

	/**
	 * 金额转换分转换为元
	 * 
	 * @param amount
	 * @return
	 */
	public static BigDecimal fenToYuan(BigDecimal amount) {
		return (amount == null ? null : amount.movePointLeft(2));
	}

	/**
	 * 金额转换元转换为分
	 * 
	 * @param amount
	 * @return
	 */
	private static BigDecimal yuanToFen(BigDecimal amount) {
		return (amount == null ? null : amount.movePointRight(2));
	}

	/**
	 * 金额转换
	 * @param amount
	 * @return
	 */
	public static Integer yuanToFenInt(BigDecimal amount) {
		return getInt(yuanToFen(amount));
	}
	
	public static Integer getInt(BigDecimal refundCount) {
		return (refundCount == null ? 0 : refundCount.intValue());
	}

	
}
