/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.comment;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.ICommentNodeProcessorMatcher;
import org.thymeleaf.processor.IProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.processor.ProcessorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommentNodeProcessor
extends AbstractProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ICommentNodeProcessorMatcher matcher;

    protected AbstractCommentNodeProcessor(ICommentNodeProcessorMatcher matcher) {
        this.matcher = matcher;
    }

    public final IProcessorMatcher<? extends Comment> getMatcher() {
        return this.matcher;
    }

    @Override
    protected final ProcessorResult doProcess(Arguments arguments, ProcessorMatchingContext processorMatchingContext, Node node) {
        if (this.logger.isTraceEnabled()) {
            String content = ((Comment)node).getContent();
            this.logger.trace("[THYMELEAF][{}][{}] Processing Comment node with content \"{}\"", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), node.getClass().getSimpleName(), content});
        }
        return this.processCommentNode(arguments, (Comment)node);
    }

    protected abstract ProcessorResult processCommentNode(Arguments var1, Comment var2);
}

