/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.MessageResolution;
import org.thymeleaf.resourceresolver.ClassLoaderResourceResolver;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageResolutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessageResolutionUtils.class);
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String SUFFIX_FOR_DEFAULT = "";
    private static final Pattern CLASS_NAME_SEPARATOR_PATTERN = Pattern.compile("\\.");
    private static final String CLASS_CACHE_PREFIX = "{class_msg}";

    public static String resolveMessageForTemplate(Arguments arguments, String messageKey, Object[] messageParameters) {
        return MessageResolutionUtils.resolveMessageForTemplate(arguments, messageKey, messageParameters, true);
    }

    public static String resolveMessageForTemplate(Arguments arguments, String messageKey, Object[] messageParameters, boolean returnStringAlways) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(arguments.getContext(), "Context cannot be null");
        Validate.notNull(messageKey, "Message key cannot be null");
        Set<IMessageResolver> messageResolvers = arguments.getConfiguration().getMessageResolvers();
        MessageResolution messageResolution = null;
        for (IMessageResolver messageResolver : messageResolvers) {
            if (messageResolution != null) continue;
            messageResolution = messageResolver.resolveMessage(arguments, messageKey, messageParameters);
        }
        if (messageResolution == null) {
            if (!returnStringAlways) {
                return null;
            }
            return MessageResolutionUtils.getAbsentMessageRepresentation(messageKey, arguments.getContext().getLocale());
        }
        return messageResolution.getResolvedMessage();
    }

    public static String resolveMessageForClass(Configuration configuration, Class<?> targetClass, Locale locale, String messageKey, Object[] messageParameters) {
        return MessageResolutionUtils.resolveMessageForClass(configuration, targetClass, locale, messageKey, messageParameters, true);
    }

    public static String resolveMessageForClass(Configuration configuration, Class<?> targetClass, Locale locale, String messageKey, Object[] messageParameters, boolean returnStringAlways) {
        String messageValue;
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(targetClass, "Target class cannot be null");
        Validate.notNull(locale, "Locale in context cannot be null");
        Validate.notNull(messageKey, "Message key cannot be null");
        String className = targetClass.getName();
        String cacheKey = CLASS_CACHE_PREFIX + className + "_" + locale.toString();
        ICache<String, Properties> messagesCache = null;
        Properties properties = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (messagesCache = cacheManager.getMessageCache()) != null) {
            properties = messagesCache.get(cacheKey);
        }
        if (properties == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("[THYMELEAF][{}] Resolving uncached messages for class \"{}\" and locale \"{}\". Messages will be retrieved from files", new Object[]{TemplateEngine.threadIndex(), targetClass.getName(), locale});
            }
            properties = MessageResolutionUtils.loadMessagesForClass(targetClass, locale);
            if (messagesCache != null) {
                messagesCache.put(cacheKey, properties);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Resolving messages for class \"{}\" and locale \"{}\". Messages are CACHED", new Object[]{TemplateEngine.threadIndex(), targetClass.getName(), locale});
        }
        if ((messageValue = properties.getProperty(messageKey)) == null) {
            if (returnStringAlways) {
                return MessageResolutionUtils.getAbsentMessageRepresentation(messageKey, locale);
            }
            return null;
        }
        if (messageParameters == null || messageParameters.length == 0) {
            return messageValue;
        }
        MessageFormat messageFormat = new MessageFormat(messageValue, locale);
        return messageFormat.format(messageParameters);
    }

    public static String getAbsentMessageRepresentation(String messageKey, Locale locale) {
        Validate.notNull(messageKey, "Message key cannot be null");
        if (locale != null) {
            return "??" + messageKey + "_" + locale.toString() + "??";
        }
        return "??" + messageKey + "_" + "??";
    }

    private static Properties loadMessagesForClass(Class<?> targetClass, Locale locale) {
        Validate.notNull(targetClass, "Target class cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        ArrayList<Properties> properties = new ArrayList<Properties>(5);
        Class<?> currentClass = targetClass;
        String base = MessageResolutionUtils.getClassNameBase(currentClass);
        properties.add(MessageResolutionUtils.loadCombinedMessagesFilesFromBaseName(null, null, base, locale, null));
        while (!currentClass.getSuperclass().equals(Object.class)) {
            currentClass = currentClass.getSuperclass();
            base = MessageResolutionUtils.getClassNameBase(currentClass);
            properties.add(MessageResolutionUtils.loadCombinedMessagesFilesFromBaseName(null, null, base, locale, null));
        }
        return MessageResolutionUtils.combineMessages(properties, null);
    }

    public static Properties loadCombinedMessagesFilesFromBaseName(Arguments arguments, IResourceResolver resourceResolver, String baseName, Locale locale, Properties defaultMessages) {
        Validate.notNull(baseName, "Base name cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        List<String> messageResourceNames = MessageResolutionUtils.getMessageFileNamesFromBase(baseName, locale);
        IResourceResolver usedResourceResolver = resourceResolver != null ? resourceResolver : new ClassLoaderResourceResolver();
        ArrayList<Properties> messages = new ArrayList<Properties>(10);
        Iterator<String> iterator = messageResourceNames.iterator();
        while (iterator.hasNext()) {
            String messageResourceName;
            InputStream messageFileInputStream = usedResourceResolver.getResourceAsStream(arguments == null ? null : arguments.getTemplateProcessingParameters(), messageResourceName = iterator.next());
            if (messageFileInputStream == null) continue;
            messages.add(MessageResolutionUtils.loadMessages(messageFileInputStream));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("[THYMELEAF][{}] Loading messages for locale \"{}\" from processed file: {}", new Object[]{TemplateEngine.threadIndex(), locale, messageResourceName});
        }
        return MessageResolutionUtils.combineMessages(messages, defaultMessages);
    }

    private static Properties combineMessages(List<Properties> props, Properties defaultMessages) {
        Validate.notNull(props, "Message specifications cannot be null");
        Properties messages = defaultMessages == null ? new Properties() : new Properties(defaultMessages);
        for (Properties messagesSpecification : props) {
            if (messagesSpecification == null) continue;
            for (Map.Entry<Object, Object> entry : messagesSpecification.entrySet()) {
                if (messages.containsKey(entry.getKey())) continue;
                messages.put(entry.getKey(), entry.getValue());
            }
        }
        return messages;
    }

    private static Properties loadMessages(InputStream propertiesIS) {
        if (propertiesIS == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(propertiesIS);
        }
        catch (Exception e) {
            throw new TemplateInputException("Exception loading messages file", e);
        }
        finally {
            try {
                propertiesIS.close();
            }
            catch (Exception e) {}
        }
        return properties;
    }

    private static List<String> getMessageFileNamesFromBase(String messagesFileNameBase, Locale locale) {
        String propertiesFileName;
        ArrayList<String> propertiesFileNames = new ArrayList<String>(5);
        if (StringUtils.isEmptyOrWhitespace(locale.getLanguage())) {
            throw new TemplateProcessingException("Locale \"" + locale.toString() + "\" " + "cannot be used as it does not specify a language.");
        }
        if (!StringUtils.isEmptyOrWhitespace(locale.getVariant())) {
            propertiesFileName = MessageResolutionUtils.getMessagesFileNameWithSuffix(messagesFileNameBase, MessageResolutionUtils.getSuffixForLanguageCountryVariant(locale));
            propertiesFileNames.add(propertiesFileName);
        }
        if (!StringUtils.isEmptyOrWhitespace(locale.getCountry())) {
            propertiesFileName = MessageResolutionUtils.getMessagesFileNameWithSuffix(messagesFileNameBase, MessageResolutionUtils.getSuffixForLanguageCountry(locale));
            propertiesFileNames.add(propertiesFileName);
        }
        if (!StringUtils.isEmptyOrWhitespace(locale.getLanguage())) {
            propertiesFileName = MessageResolutionUtils.getMessagesFileNameWithSuffix(messagesFileNameBase, MessageResolutionUtils.getSuffixForLanguage(locale));
            propertiesFileNames.add(propertiesFileName);
        }
        propertiesFileName = MessageResolutionUtils.getMessagesFileNameWithSuffix(messagesFileNameBase, SUFFIX_FOR_DEFAULT);
        propertiesFileNames.add(propertiesFileName);
        return propertiesFileNames;
    }

    private static String getClassNameBase(Class<?> targetClass) {
        return CLASS_NAME_SEPARATOR_PATTERN.matcher(targetClass.getName()).replaceAll("/");
    }

    private static String getMessagesFileNameWithSuffix(String baseFileName, String suffix) {
        if (StringUtils.isEmptyOrWhitespace(suffix)) {
            return baseFileName + PROPERTIES_SUFFIX;
        }
        return baseFileName + "_" + suffix + PROPERTIES_SUFFIX;
    }

    private static String getSuffixForLanguageCountryVariant(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry() + "-" + locale.getVariant();
    }

    private static String getSuffixForLanguageCountry(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    private static String getSuffixForLanguage(Locale locale) {
        return locale.getLanguage();
    }

    private MessageResolutionUtils() {
    }
}

