package com.ylzinfo.onepay.sdk.domain;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.ylzinfo.onepay.sdk.enums.Channel;

public class ChargeParams implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String termNo; // 交易终端编号
	/**
	 * 渠道， 根据不同场景选择不同的支付方式
	 */
	private Channel channel;
	
	/**
	 * 版本， 根据不同版本调用不同支付接口
	 */
	private String version;

	/**
	 * 商户订单号, 32个字符内，数字和字母组合，确保在商户系统中唯一
	 */
	private String outChargeNo;

	/**
	 * 商户订单日期，日期格式为yyyy-MM-dd HH:mm:ss
	 */
	private String outChargeTime;

	/**
	 * 订单总金额， 只能为整数，单位为分，例如 1
	 */
	private Integer chargeAmt;

	/**
	 * 商品标题
	 */
	private String subject;

	/**
	 * 商口描述
	 */
	private String body;

	/**
	 * 客户端地址
	 */
	private String clientIp;

	/**
	 * 附加数据， 用户自定义的参数，将会回调中原样返回，该字段主要用于商户携带订单的自定义数据
	 */
	private Map<String, String> optional;

	/**
	 * 异步通知地址 ， 可空
	 */
	private String notifyUrl;

	/**
	 * 同步返回页面 ， 支付渠道处理完请求后,当前页面自动跳转到商户网站里指定页面的http路径。当 channel 参数为 ALI_WEB 或
	 * ALI_QRCODE 或 UP_WEB时为必填
	 */
	private String returnUrl;

	/**
	 * 商品展示地址，需以http://开头的完整路径
	 */
	private String showUrl;

	/**
	 * 扩展入参
	 * 
	 * 包括
	 * 
	 * 微信公众号支付(WX_PUB)必填 openId
	 */
	private Map<String, String> extra;
	
	/**
	 * 订单详情列表
	 */
	private List<ChargeGoodsDetailVO> chargeGoodsDetail;

	/**
	 * 操作员编号
	 */
	private String operatorId;
	
	/**
	 * 操作员姓名
	 */
	private String operatorName;

	/**
	 * 支付人员编号
	 */
	private String payerId;
	
	/**
	 * 支付人员姓名
	 */
	private String payerName;
	
	/**
	 * 是否支持信用卡支付：0或空是，1否
	 */
	private String isCreditCard;

	/**
	 * 订单描述
	 */ String description;
	
	public String getIsCreditCard() {
		return isCreditCard;
	}

	public void setIsCreditCard(String isCreditCard) {
		this.isCreditCard = isCreditCard;
	}

	public String getPayerId() {
		return payerId;
	}

	public void setPayerId(String payerId) {
		this.payerId = payerId;
	}

	public String getPayerName() {
		return payerName;
	}

	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}

	public String getOperatorId() {
		return operatorId;
	}

	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}

	public String getOperatorName() {
		return operatorName;
	}

	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public List<ChargeGoodsDetailVO> getChargeGoodsDetail() {
		return chargeGoodsDetail;
	}

	public void setChargeGoodsDetail(List<ChargeGoodsDetailVO> chargeGoodsDetail) {
		this.chargeGoodsDetail = chargeGoodsDetail;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getNotifyUrl() {
		return notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public Channel getChannel() {
		return channel;
	}

	public void setChannel(Channel channel) {
		this.channel = channel;
	}

	public Integer getChargeAmt() {
		return chargeAmt;
	}

	public void setChargeAmt(Integer chargeAmt) {
		this.chargeAmt = chargeAmt;
	}

	public String getOutChargeNo() {
		return outChargeNo;
	}

	public void setOutChargeNo(String outChargeNo) {
		this.outChargeNo = outChargeNo;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public Map<String, String> getOptional() {
		return optional;
	}

	public void setOptional(Map<String, String> optional) {
		this.optional = optional;
	}

	public String getReturnUrl() {
		return returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getShowUrl() {
		return showUrl;
	}

	public void setShowUrl(String showUrl) {
		this.showUrl = showUrl;
	}

	public String getOutChargeTime() {
		return outChargeTime;
	}

	public void setOutChargeTime(String outChargeTime) {
		this.outChargeTime = outChargeTime;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getClientIp() {
		return clientIp;
	}

	public void setClientIp(String clientIp) {
		this.clientIp = clientIp;
	}

	public Map<String, String> getExtra() {
		return extra;
	}

	public void setExtra(Map<String, String> extra) {
		this.extra = extra;
	}

	public String getTermNo() {
		return termNo;
	}

	public void setTermNo(String termNo) {
		this.termNo = termNo;
	}

}
