package com.ylzinfo.onepay.sdk.domain;

import java.io.Serializable;
import java.util.Map;

import com.ylzinfo.onepay.sdk.enums.Channel;

/**
 * @Title: ChargeVO.java
 * @Description:
 * @Author: zwsun @Date 2015年9月29日
 * @version V1.0
 */
public class ChargeVO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 订单号
	 */
	private String chargeNo;

	/**
	 * 商户订单号
	 */
	private String outChargeNo;

	/**
	 * 订单日期
	 */
	private String outChargeTime;

	/**
	 * 订单名称
	 */
	private String subject;

	/**
	 * 支付渠道标识
	 */
	private Channel channel;

	/**
	 * 订单状态
	 */
	private String chargeStatus;

	/**
	 * 订单金额，以分为单位
	 */
	private Integer chargeAmt;

	/**
	 * 订单支付时间
	 * 
	 * @return
	 */
	private String payTime;

	/**
	 * 退款金额
	 */
	private Integer refundedAmt;

	/**
	 * 正在退款金额
	 */
	private Integer refundingAmt;

	/**
	 * 退款笔数
	 */
	private Integer refundCount;

	/**
	 * 订单属性
	 */
	private Map<String, String> optional;
	
//	private String externalNo;//微信支付/支付宝 订单号

	public Map<String, String> getOptional() {
		return optional;
	}

	public void setOptional(Map<String, String> optional) {
		this.optional = optional;
	}

	public Integer getRefundedAmt() {
		return refundedAmt;
	}

	public void setRefundedAmt(Integer refundedAmt) {
		this.refundedAmt = refundedAmt;
	}

	public Integer getRefundingAmt() {
		return refundingAmt;
	}

	public void setRefundingAmt(Integer refundingAmt) {
		this.refundingAmt = refundingAmt;
	}

	public Integer getRefundCount() {
		return refundCount;
	}

	public void setRefundCount(Integer refundCount) {
		this.refundCount = refundCount;
	}

	public String getPayTime() {
		return payTime;
	}

	public void setPayTime(String payTime) {
		this.payTime = payTime;
	}

/*	public String getExternalNo() {
		return externalNo;
	}

	public void setExternalNo(String externalNo) {
		this.externalNo = externalNo;
	}
*/
	public String getOutChargeNo() {
		return outChargeNo;
	}

	public void setOutChargeNo(String outChargeNo) {
		this.outChargeNo = outChargeNo;
	}

	public String getOutChargeTime() {
		return outChargeTime;
	}

	public void setOutChargeTime(String outChargeTime) {
		this.outChargeTime = outChargeTime;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public Channel getChannel() {
		return channel;
	}

	public void setChannel(Channel channel) {
		this.channel = channel;
	}

	public String getChargeStatus() {
		return chargeStatus;
	}

	public void setChargeStatus(String chargeStatus) {
		this.chargeStatus = chargeStatus;
	}

	public Integer getChargeAmt() {
		return chargeAmt;
	}

	public void setChargeAmt(Integer chargeAmt) {
		this.chargeAmt = chargeAmt;
	}

	public String getChargeNo() {
		return chargeNo;
	}

	public void setChargeNo(String chargeNo) {
		this.chargeNo = chargeNo;
	}

}
