package com.ylzinfo.onepay.sdk.domain;

import java.io.Serializable;
import java.util.Map;

/**
 * @Title: CloseParams.java
 * @Description: 关闭请求参数
 * @Author: zwsun @Date 2016年11月1日
 * @version V1.0
 */
public class CloseParams implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String termNo; // 交易终端编号
	
	/**
	 * 订单号
	 */
	String outChargeNo;
	
	/**
	 * 关闭流水号
	 */
	String outCloseNo;
	
	/**
	 * 附加数据， 用户自定义的参数，将会回调中原样返回，该字段主要用于商户携带订单的自定义数据
	 */
	Map<String, String> optional;

	private String closeReason;

	public String getOutChargeNo() {
		return outChargeNo;
	}

	public void setOutChargeNo(String outChargeNo) {
		this.outChargeNo = outChargeNo;
	}

	public String getOutCloseNo() {
		return outCloseNo;
	}

	public void setOutCloseNo(String outCloseNo) {
		this.outCloseNo = outCloseNo;
	}
	
	public Map<String, String> getOptional() {
		return optional;
	}

	public void setOptional(Map<String, String> optional) {
		this.optional = optional;
	}

	public String getCloseReason() {
		return closeReason;
	}

	public void setCloseReason(String closeReason) {
		this.closeReason = closeReason;
	}

	public String getTermNo() {
		return termNo;
	}

	public void setTermNo(String termNo) {
		this.termNo = termNo;
	}

}
