package com.ylzinfo.onepay.sdk.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;

import com.ylzinfo.onepay.sdk.utils.StringUtil;

public class RequestParams implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String termNo; // 交易终端编号
	
	private Boolean isSub2Page;
	
	/**
	 * 应用id
	 */
	private String appId;

	/**
	 * 请求参数
	 */
	private Object param;

	/**
	 * 签名
	 */
	private String sign;
	
	/**
	 * 时间戳
	 */
	private String timestamp;
	
	/**
	 * 交易类型
	 */
	private String transType;
	
	private Map<String,Object> extenalMap;
	
	/**
	 * 签名类型
	 */
	private String signType;
	
	/**
	 * 加密类型
	 */
	private String encryptType;
	
	/**
	 * 版本号
	 */
	private String version;
	
	/**
	 * 密文
	 */
	private String encryptData;
	
	private String isCreditCard;
	
	public Boolean getIsSub2Page() {
		return isSub2Page;
	}

	public void setIsSub2Page(Boolean isSub2Page) {
		this.isSub2Page = isSub2Page;
	}

	public String getIsCreditCard() {
		return isCreditCard;
	}

	public void setIsCreditCard(String isCreditCard) {
		this.isCreditCard = isCreditCard;
	}

	/**
	 * 分页查询参数,主要有pageNo、pageSize add by xuwy
	 **/
	private Map<String, Object> pageParam;
	
	public String getSignType() {
		return signType;
	}

	public void setSignType(String signType) {
		this.signType = signType;
	}

	public String getEncryptType() {
		return encryptType;
	}

	public void setEncryptType(String encryptType) {
		this.encryptType = encryptType;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getEncryptData() {
		return encryptData;
	}

	public void setEncryptData(String encryptData) {
		this.encryptData = encryptData;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public Object getParam() {
		return param;
	}

	public void setParam(Object param) {
		this.param = param;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(String timestamp) {
		this.timestamp = timestamp;
	}

	public String getTransType() {
		return transType;
	}

	public void setTransType(String transType) {
		this.transType = transType;
	}

	public Boolean isSub2Page() {
		return isSub2Page;
	}

	public void setSub2Page(Boolean isSub2Page) {
		this.isSub2Page = isSub2Page;
	}

	public Map<String, Object> getExtenalMap() {
		return extenalMap;
	}

	public void setExtenalMap(Map<String, Object> extenalMap) {
		this.extenalMap = extenalMap;
	}
	
	public String getParamsAsStr(String key) {
		Object obj = extenalMap.get(key);
		return (obj == null ? "" : (String) obj);
	}
	
	public String getParamsAsTrimStr(String key) {
		Object obj = extenalMap.get(key);
		return (obj == null ? "" : ((String) obj).trim());
	}

	public BigDecimal getParamsAsBigDecimal(String key) {
		String obj = getParamsAsStr(key);
		return (StringUtil.isEmpty(obj) ? BigDecimal.ZERO : new BigDecimal(obj));
	}

	public String getTermNo() {
		return termNo;
	}

	public void setTermNo(String termNo) {
		this.termNo = termNo;
	}

	public Map<String, Object> getPageParam() {
		return pageParam;
	}

	public void setPageParam(Map<String, Object> pageParam) {
		this.pageParam = pageParam;
	}
}
