package com.ylzinfo.onepay.sdk.domain.ext;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;

import com.ylzinfo.onepay.sdk.enums.Channel;

public class RechargeConsumeResult implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 请求入口
	 */
	private String url;

	/**
	 * 二维码串
	 */
	private String qrcode;

	/**
	 * HTML执行脚本
	 */
	private String html;

	/**
	 * 跳转连接
	 */
	private String directUrl;

	/**
	 * 客户端支付凭证数据 包括 wxPubPay wxAppPay aliAppPay
	 */
	private Map<String, Object> credential;

	/**
	 * 渠道， 根据不同场景不同的支付方式
	 */
	private Channel channel;

	/**
	 * 订单属性
	 */
	private Map<String, String> optional;

	/**
	 * 商户订单号
	 */
	private String outChargeNo;

	/**
	 * 平台订单号
	 */
	private String chargeNo;

	/**
	 * 余额
	 * 
	 * @return
	 */
	private BigDecimal balance;

	/**
	 * 平台交易日期
	 */
	private String traceTime;

	/**
	 * 交易跟踪号
	 */
	private String traceNo;

	public String getOutChargeNo() {
		return outChargeNo;
	}

	public void setOutChargeNo(String outChargeNo) {
		this.outChargeNo = outChargeNo;
	}

	public String getChargeNo() {
		return chargeNo;
	}

	public void setChargeNo(String chargeNo) {
		this.chargeNo = chargeNo;
	}

	public Channel getChannel() {
		return channel;
	}

	public void setChannel(Channel channel) {
		this.channel = channel;
	}

	public String getDirectUrl() {
		return directUrl;
	}

	public void setDirectUrl(String directUrl) {
		this.directUrl = directUrl;
	}

	public String getHtml() {
		return html;
	}

	public void setHtml(String html) {
		this.html = html;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Map<String, Object> getCredential() {
		return credential;
	}

	public void setCredential(Map<String, Object> credential) {
		this.credential = credential;
	}

	public Map<String, String> getOptional() {
		return optional;
	}

	public void setOptional(Map<String, String> optional) {
		this.optional = optional;
	}

	public String getQrcode() {
		return qrcode;
	}

	public void setQrcode(String qrcode) {
		this.qrcode = qrcode;
	}

	public BigDecimal getBalance() {
		return balance;
	}

	public void setBalance(BigDecimal balance) {
		this.balance = balance;
	}

	public String getTraceTime() {
		return traceTime;
	}

	public void setTraceTime(String traceTime) {
		this.traceTime = traceTime;
	}

	public String getTraceNo() {
		return traceNo;
	}

	public void setTraceNo(String traceNo) {
		this.traceNo = traceNo;
	}

}
