/**
 * 软件著作权：厦门恒隆兴公司软件开发中心
 * 
 * 系统名称：统一支付项目
 * 
 */
package com.ylzinfo.onepay.sdk.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * Bean工具类
 * 
 * @author chenliang
 * @version 1.0.0
 */
public class BeanUtil {

	/**
	 * Bean转换Map
	 * @param Object:待转换Bean          
	 * @return Map<Object,Object>:转换成的Map
	 * @throws Exception
	 */
	public static Map<String, Object> Bean2Map(Object inObj, boolean ignoreNull) throws Exception {

		Map<String, Object> retMap = new HashMap<String, Object>();
		if (inObj != null) {
			try {
				Class<? extends Object> cls = inObj.getClass();
				BeanInfo beanInfo = Introspector.getBeanInfo(cls);
				PropertyDescriptor[] propertyDescriptors = beanInfo
						.getPropertyDescriptors();
				for (int i = 0; i < propertyDescriptors.length; i++) {
					PropertyDescriptor descriptor = propertyDescriptors[i];
					String propertyName = descriptor.getName();
					if (!propertyName.equals("class")) {
						Method readMethod = descriptor.getReadMethod();
						Object result = readMethod.invoke(inObj, new Object[0]);
						if (result != null) {
							//出于对object C JSON的兼容
							if (result instanceof BigDecimal) {
								result = ((BigDecimal) result).setScale(2, BigDecimal.ROUND_HALF_UP);
							}
							retMap.put(propertyName, result);
						} else if (!ignoreNull){
							retMap.put(propertyName, "");
						}
					}
				}

			} catch (Exception err) {
				err.printStackTrace();
			}
		}
		return retMap;
	}
	

	/**
	 * Map转换Bean
	 * @param inObj:需要转换成的Object 
	 * @param Map<Object,Object>:待转换Map 
	 * @return Object：转换后的对象实例
	 * @throws Exception
	 */
	public static Object Map2Bean(Object inObj, Map<Object, Object> inMap)
			throws Exception {
		if (inObj == null || inMap == null) {
			return null;
		}
		Class<? extends Object> cls = inObj.getClass();
		BeanInfo beanInfo = Introspector.getBeanInfo(cls); /* 获取类属性 */
		Object obj = cls.newInstance(); /* 创建JavaBean对象 */
		/* 给 JavaBean 对象的属性赋值 */
		try {
			PropertyDescriptor[] propertyDescriptors = beanInfo
					.getPropertyDescriptors();
			for (int i = 0; i < propertyDescriptors.length; i++) {
				PropertyDescriptor descriptor = propertyDescriptors[i];
				String propertyName = descriptor.getName();
				if (inMap.containsKey(propertyName)) {
					Object value = inMap.get(propertyName);
					Object[] args = new Object[1];
					args[0] = value;
					descriptor.getWriteMethod().invoke(obj, args);
				}
			}
		} catch (Exception err) {
			err.printStackTrace();
		}
		return obj;
	}
	
	/**
	 * Map转换Bean
	 * @param <T>
	 * @param inObj:需要转换成的Object 
	 * @param Map<String,Object>:待转换Map 
	 * @return Object：转换后的对象实例
	 * @throws Exception
	 */
	public static <T> T MapToBean(Class<T>  inObj, Map<String, Object> inMap)
			throws Exception {
		if (inObj == null || inMap == null) {
			return null;
		}
//		Class<? extends Object> cls = inObj.getClass();
		BeanInfo beanInfo = Introspector.getBeanInfo(inObj); /* 获取类属性 */
		T obj = inObj.newInstance(); /* 创建JavaBean对象 */
		/* 给 JavaBean 对象的属性赋值 */
		try {
			PropertyDescriptor[] propertyDescriptors = beanInfo
					.getPropertyDescriptors();
			for (int i = 0; i < propertyDescriptors.length; i++) {
				PropertyDescriptor descriptor = propertyDescriptors[i];
				String propertyName = descriptor.getName();
				if (inMap.containsKey(propertyName)) {
					Object value = inMap.get(propertyName);
					Object[] args = new Object[1];
					args[0] = value;
					descriptor.getWriteMethod().invoke(obj, args);
				}
			}
		} catch (Exception err) {
			err.printStackTrace();
		}
		return obj;
	}
}
