/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.listener;

import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class KeyspaceEventMessageListener
implements MessageListener,
InitializingBean,
DisposableBean {
    private final RedisMessageListenerContainer listenerContainer;
    private static final Topic TOPIC_ALL_KEYEVENTS = new PatternTopic("__keyevent@*");

    public KeyspaceEventMessageListener(RedisMessageListenerContainer listenerContainer) {
        Assert.notNull((Object)listenerContainer, (String)"RedisMessageListenerContainer to run in must not be null!");
        this.listenerContainer = listenerContainer;
    }

    @Override
    public void onMessage(Message message, byte[] pattern) {
        if (message == null || message.getChannel() == null || message.getBody() == null) {
            return;
        }
        this.doHandleMessage(message);
    }

    protected abstract void doHandleMessage(Message var1);

    public void init() {
        RedisConnection connection = this.listenerContainer.getConnectionFactory().getConnection();
        List<String> config = connection.getConfig("notify-keyspace-events");
        if (config.size() == 2 && !StringUtils.hasText((String)config.get(1))) {
            connection.setConfig("notify-keyspace-events", "KEA");
        }
        connection.close();
        this.doRegister(this.listenerContainer);
    }

    protected void doRegister(RedisMessageListenerContainer container) {
        this.listenerContainer.addMessageListener((MessageListener)this, TOPIC_ALL_KEYEVENTS);
    }

    public void destroy() throws Exception {
        this.listenerContainer.removeMessageListener(this);
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }
}

