/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class PathResourceResolver
extends AbstractResourceResolver {
    private Resource[] allowedLocations;

    public void setAllowedLocations(Resource ... locations) {
        this.allowedLocations = locations;
    }

    public Resource[] getAllowedLocations() {
        return this.allowedLocations;
    }

    @Override
    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(requestPath, locations);
    }

    @Override
    protected String resolveUrlPathInternal(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return StringUtils.hasText((String)resourcePath) && this.getResource(resourcePath, locations) != null ? resourcePath : null;
    }

    private Resource getResource(String resourcePath, List<? extends Resource> locations) {
        for (Resource resource : locations) {
            try {
                Resource resource2;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Checking location: " + resource));
                }
                if ((resource2 = this.getResource(resourcePath, resource)) != null) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Found match: " + resource2));
                    }
                    return resource2;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace((Object)("No match for location: " + resource));
            }
            catch (IOException ex) {
                this.logger.trace((Object)"Failure checking for relative resource - trying next location", (Throwable)ex);
            }
        }
        return null;
    }

    protected Resource getResource(String resourcePath, Resource location) throws IOException {
        Resource resource = location.createRelative(resourcePath);
        if (resource.exists() && resource.isReadable()) {
            if (this.checkResource(resource, location)) {
                return resource;
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Resource path=\"" + resourcePath + "\" was successfully resolved " + "but resource=\"" + resource.getURL() + "\" is neither under the " + "current location=\"" + location.getURL() + "\" nor under any of the " + "allowed locations=" + Arrays.asList(this.getAllowedLocations())));
            }
        }
        return null;
    }

    protected boolean checkResource(Resource resource, Resource location) throws IOException {
        if (this.isResourceUnderLocation(resource, location)) {
            return true;
        }
        if (this.getAllowedLocations() != null) {
            for (Resource current : this.getAllowedLocations()) {
                if (!this.isResourceUnderLocation(resource, current)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isResourceUnderLocation(Resource resource, Resource location) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            resourcePath = ((ClassPathResource)resource).getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)location).getPath());
        } else if (resource instanceof ServletContextResource) {
            resourcePath = ((ServletContextResource)resource).getPath();
            locationPath = StringUtils.cleanPath((String)((ServletContextResource)location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        String string = locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        if (!resourcePath.startsWith(locationPath)) {
            return false;
        }
        if (resourcePath.contains("%") && URLDecoder.decode(resourcePath, "UTF-8").contains("../")) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Resolved resource path contains \"../\" after decoding: " + resourcePath));
            }
            return false;
        }
        return true;
    }
}

