package com.ylzinfo.onepay.sdk.domain;

import java.io.Serializable;
import java.util.Map;

import com.ylzinfo.onepay.sdk.enums.Channel;

public class ChargeResult implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 请求入口
	 */
	private String url;

	/**
	 * 二维码串
	 */
	private String qrcode;

	/**
	 * HTML执行脚本
	 */
	private String html;

	/**
	 * 跳转连接
	 */
	private String directUrl;

	/**
	 * 客户端支付凭证数据 
	 */
	private Map<String, Object> credential;

	/**
	 * 渠道， 根据不同场景选择不同的支付方式
	 */
	private Channel channel;

	/**
	 * 订单属性
	 */
	private Map<String, String> optional;

	/**
	 * 商户订单号
	 */
	private String outChargeNo;

	/**
	 * 平台订单号
	 */
	private String chargeNo;

	/**
	 * 订单状态
	 */
	private String chargeStatus;

	/**
	 * 下单时间
	 */
	private String chargeTime;

	/**
	 * 订单名称
	 */
	private String chargeName;
	
//	private String externalNo;//微信支付/支付宝 订单号

	public String getChargeStatus() {
		return chargeStatus;
	}

	public void setChargeStatus(String chargeStatus) {
		this.chargeStatus = chargeStatus;
	}

	public String getOutChargeNo() {
		return outChargeNo;
	}

	public void setOutChargeNo(String outChargeNo) {
		this.outChargeNo = outChargeNo;
	}

	public String getChargeNo() {
		return chargeNo;
	}

	public void setChargeNo(String chargeNo) {
		this.chargeNo = chargeNo;
	}

	public Channel getChannel() {
		return channel;
	}

	public void setChannel(Channel channel) {
		this.channel = channel;
	}

	public String getDirectUrl() {
		return directUrl;
	}

/*	public String getExternalNo() {
		return externalNo;
	}

	public void setExternalNo(String externalNo) {
		this.externalNo = externalNo;
	}*/

	public void setDirectUrl(String directUrl) {
		this.directUrl = directUrl;
	}

	public String getHtml() {
		return html;
	}

	public void setHtml(String html) {
		this.html = html;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Map<String, Object> getCredential() {
		return credential;
	}

	public void setCredential(Map<String, Object> credential) {
		this.credential = credential;
	}

	public Map<String, String> getOptional() {
		return optional;
	}

	public void setOptional(Map<String, String> optional) {
		this.optional = optional;
	}

	public String getQrcode() {
		return qrcode;
	}

	public void setQrcode(String qrcode) {
		this.qrcode = qrcode;
	}

	public String getChargeTime() {
		return chargeTime;
	}

	public void setChargeTime(String chargeTime) {
		this.chargeTime = chargeTime;
	}

	public String getChargeName() {
		return chargeName;
	}

	public void setChargeName(String chargeName) {
		this.chargeName = chargeName;
	}
}
