/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.spring4.dialect.SpringStandardDialect;
import org.thymeleaf.spring4.messageresolver.SpringMessageResolver;

public class SpringTemplateEngine
extends TemplateEngine
implements MessageSourceAware,
InitializingBean {
    private static final SpringStandardDialect SPRINGSTANDARD_DIALECT = new SpringStandardDialect();
    private MessageSource messageSource = null;
    private MessageSource templateEngineMessageSource = null;

    public SpringTemplateEngine() {
        super.addDialect((IDialect)SPRINGSTANDARD_DIALECT);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setTemplateEngineMessageSource(MessageSource templateEngineMessageSource) {
        this.templateEngineMessageSource = templateEngineMessageSource;
    }

    public void afterPropertiesSet() throws Exception {
        SpringMessageResolver springMessageResolver = new SpringMessageResolver();
        springMessageResolver.setMessageSource(this.templateEngineMessageSource == null ? this.messageSource : this.templateEngineMessageSource);
        super.setDefaultMessageResolvers(Collections.singleton(springMessageResolver));
    }

    protected final void initializeSpecific() {
        Configuration configuration = this.getConfiguration();
        Map dialects = configuration.getDialects();
        for (IDialect dialect : dialects.values()) {
            if (!(dialect instanceof SpringStandardDialect)) continue;
            this.initializeSpringSpecific();
            return;
        }
        throw new ConfigurationException("When using " + SpringTemplateEngine.class.getSimpleName() + ", at least one of the configured dialects must be or extend " + SpringStandardDialect.class.getName() + ".");
    }

    protected void initializeSpringSpecific() {
    }
}

