/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.openplatform.service;

import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import com.yihu.config.ConfigReader;
import com.yihu.openplatform.utils.BeanUtils;
import com.yihu.openplatform.utils.DateJsonValueProcessor;
import com.yihu.openplatform.utils.DictConfigUtil;
import com.yihu.openplatform.vo.ApiChanelPriv;
import com.yihu.openplatform.vo.ApiReturnCodeVo;
import com.yihu.wsgw.api.ServiceBus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApiReturnCodeService
extends TimerTask {
    private static final Log log = LogFactory.getLog(ApiReturnCodeService.class);
    private static Map<Integer, ApiReturnCodeVo> apiReturnCodes = null;
    private static Map<String, ApiChanelPriv> apiChanelPrivs = null;
    private static boolean isFirstLoad = true;
    private static long reflashTime = 300000L;
    private static String appId = null;
    public static String wsgw_enableIpControl = null;
    public static String wsgw_ip = null;

    public static ApiChanelPriv getApiChanelPriv(String apiName) {
        if (apiChanelPrivs == null) {
            return null;
        }
        return apiChanelPrivs.get(apiName);
    }

    public static ApiReturnCodeVo getApiReturnCode(Integer codeId) {
        if (apiReturnCodes == null) {
            return null;
        }
        return apiReturnCodes.get(codeId);
    }

    public static String getMessage(Integer codeId) {
        return ApiReturnCodeService.getMessage(codeId, true);
    }

    public static String getMessage(Integer codeId, boolean addCodeId) {
        if (apiReturnCodes == null) {
            return "\u9519\u8bef\u7cfb\u7edf\u5c1a\u672a\u521d\u59cb\u5316,\u65e0\u9519\u8bef\u4fe1\u606fcodeId=" + codeId;
        }
        ApiReturnCodeVo apiReturnCode = ApiReturnCodeService.getApiReturnCode(codeId);
        if (apiReturnCode == null) {
            return "\u65e0\u9519\u8bef\u4fe1\u606f\uff0ccodeId=" + codeId;
        }
        if (addCodeId) {
            return String.valueOf(apiReturnCode.getMessage()) + ",codeId=" + apiReturnCode.getCodeId();
        }
        return apiReturnCode.getMessage();
    }

    public static boolean checkApiChanelPriv(String apiName, String appId) {
        if (apiName != null && apiChanelPrivs != null) {
            ApiChanelPriv apiChanelPriv = apiChanelPrivs.get(apiName);
            if (apiChanelPriv != null && apiChanelPriv.getAppIds() != null && apiChanelPriv.getAppIds().indexOf("," + appId + ",") < 0) {
                return false;
            }
            if (apiChanelPriv != null && apiChanelPriv.getAppIds() != null && apiChanelPriv.getAppIds().indexOf("," + appId + ",") >= 0) {
                return true;
            }
            String[] arrApiName = apiName.split("\\.");
            System.out.print(arrApiName.length);
            if (arrApiName.length == 3) {
                apiChanelPriv = apiChanelPrivs.get(String.valueOf(arrApiName[0]) + "." + arrApiName[1]);
                if (apiChanelPriv != null && apiChanelPriv.getAppIds() != null && apiChanelPriv.getAppIds().indexOf("," + appId + ",") < 0) {
                    return false;
                }
                if (apiChanelPriv != null && apiChanelPriv.getAppIds() != null && apiChanelPriv.getAppIds().indexOf("," + appId + ",") >= 0) {
                    return true;
                }
                apiChanelPriv = apiChanelPrivs.get(arrApiName[0]);
                if (apiChanelPriv != null && apiChanelPriv.getAppIds() != null && apiChanelPriv.getAppIds().indexOf("," + appId + ",") < 0) {
                    return false;
                }
                if (apiChanelPriv != null && apiChanelPriv.getAppIds() != null && apiChanelPriv.getAppIds().indexOf("," + appId + ",") >= 0) {
                    return true;
                }
            }
        }
        return true;
    }

    private static synchronized void LoadAllReturnCode() {
        PrintWriter w;
        StringWriter sw;
        HashMap<Integer, ApiReturnCodeVo> nowApiReturnCodes = new HashMap<Integer, ApiReturnCodeVo>();
        try {
            JSONObject jsonParam = new JSONObject();
            jsonParam.put((Object)"appId", (Object)appId);
            String result = ServiceBus.getInstance((String)DictConfigUtil.getInstance().getCenterServerUrl().toString(), (String)DictConfigUtil.getInstance().getAppId()).call("ApiManager.TjCallLog.getApiReturnCode", jsonParam.toString());
            JSONObject resultJson = JSONObject.fromObject((Object)result);
            if (resultJson.containsKey((Object)"Code") && resultJson.getInt("Code") == 10000 && resultJson.containsKey((Object)"Result")) {
                JSONArray arr = resultJson.getJSONArray("Result");
                int i = 0;
                while (i < arr.size()) {
                    JSONObject obj = arr.getJSONObject(i);
                    ApiReturnCodeVo apiReturnCodeVo = new ApiReturnCodeVo();
                    BeanUtils.toBean(obj, apiReturnCodeVo);
                    if (apiReturnCodeVo.getIsValid() != null && apiReturnCodeVo.getIsValid() == 1) {
                        nowApiReturnCodes.put(apiReturnCodeVo.getCodeId(), apiReturnCodeVo);
                    }
                    ++i;
                }
                if (nowApiReturnCodes.size() > 0) {
                    apiReturnCodes = nowApiReturnCodes;
                }
            }
        }
        catch (Exception e) {
            sw = new StringWriter();
            w = new PrintWriter(sw);
            e.printStackTrace(w);
            Logger.get().error("LoadAllReturnCode", new LogBody().set("\u7c7b\uff1a", (Object)ApiReturnCodeService.class.getName()).set("\u65b9\u6cd5\uff1a", (Object)Thread.currentThread().getStackTrace()[1].getMethodName()).set("\u5f02\u5e38\uff1a", (Object)sw));
        }
        try {
            wsgw_enableIpControl = ConfigReader.me((String)DictConfigUtil.getInstance().getCenterServerUrl().toString()).getNamePair("LogGateWay", "WSGW_EnableIpControl");
        }
        catch (Exception e) {
            sw = new StringWriter();
            w = new PrintWriter(sw);
            e.printStackTrace(w);
            Logger.get().error("load wsgw_enableIpControl error", new LogBody().set("\u7c7b\uff1a", (Object)ApiReturnCodeService.class.getName()).set("\u65b9\u6cd5\uff1a", (Object)Thread.currentThread().getStackTrace()[1].getMethodName()).set("\u5f02\u5e38\uff1a", (Object)sw));
        }
        try {
            wsgw_ip = ConfigReader.me((String)DictConfigUtil.getInstance().getCenterServerUrl().toString()).getNamePair("LogGateWay", "WSGW_IP");
        }
        catch (Exception e) {
            sw = new StringWriter();
            w = new PrintWriter(sw);
            e.printStackTrace(w);
            Logger.get().error("load wsgw_ip error", new LogBody().set("\u7c7b\uff1a", (Object)ApiReturnCodeService.class.getName()).set("\u65b9\u6cd5\uff1a", (Object)Thread.currentThread().getStackTrace()[1].getMethodName()).set("\u5f02\u5e38\uff1a", (Object)sw));
        }
    }

    public static synchronized void init(String appId) {
        if (isFirstLoad) {
            isFirstLoad = false;
            ApiReturnCodeService.appId = appId.toLowerCase();
            ApiReturnCodeService.LoadAllReturnCode();
            Timer timer = new Timer();
            ApiReturnCodeService codeService = new ApiReturnCodeService();
            timer.schedule((TimerTask)codeService, reflashTime, reflashTime);
            return;
        }
    }

    public static synchronized void init(String appId, String callApiClientId) {
        if (isFirstLoad) {
            isFirstLoad = false;
            ApiReturnCodeService.appId = appId.toLowerCase();
            if (callApiClientId != null && callApiClientId.length() > 0) {
                try {
                    DictConfigUtil.getInstance().setAppId(callApiClientId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ApiReturnCodeService.LoadAllReturnCode();
            Timer timer = new Timer();
            ApiReturnCodeService codeService = new ApiReturnCodeService();
            timer.schedule((TimerTask)codeService, reflashTime, reflashTime);
            return;
        }
    }

    @Override
    public void run() {
        ApiReturnCodeService.LoadAllReturnCode();
    }

    public static JsonConfig getDefaultJSONConfig() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new DateJsonValueProcessor());
        jsonConfig.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)new DateJsonValueProcessor());
        jsonConfig.registerJsonValueProcessor(Integer.class, (JsonValueProcessor)new DateJsonValueProcessor());
        jsonConfig.registerJsonValueProcessor(Double.class, (JsonValueProcessor)new DateJsonValueProcessor());
        return jsonConfig;
    }
}

