/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.openplatform.service;

import com.yihu.openplatform.service.AppKeyService;
import com.yihu.openplatform.service.MessageSaveThread;
import com.yihu.openplatform.service.SignAndPost;
import com.yihu.openplatform.service.UrlCheck;
import com.yihu.openplatform.vo.Message;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;

public class MessagePool
implements Runnable {
    public static ArrayList[] al;
    private int nowIndex;
    private static int roundIdx;

    static {
        roundIdx = 0;
    }

    public static void init(int threadNum) {
        al = new ArrayList[threadNum];
        int i = 0;
        while (i < threadNum) {
            MessagePool.al[i] = new ArrayList();
            MessagePool messagePool = new MessagePool(i);
            Thread t = new Thread(messagePool);
            t.start();
            ++i;
        }
        System.out.println("start " + threadNum + " thread to send mesage!");
    }

    public static synchronized String pushMsg(String url, String appId, String appName, String secret, Map<String, String> oriParamMap, String encryptType, String sourceAppId, boolean syncSend, boolean isSuccess, String result) {
        Message message = new Message();
        message.setMsgId(UUID.randomUUID().toString().replaceAll("-", "").toUpperCase());
        message.setAppId(appId);
        message.setAppName(appName);
        message.setUrl(url);
        message.setEncryptType(encryptType);
        message.setOriParamMap(oriParamMap);
        message.setSecret(secret);
        if (result != null) {
            message.setResult(result);
        }
        if (syncSend) {
            message.setStatus(isSuccess ? 1 : 2);
        } else {
            message.setStatus(0);
        }
        message.setSyncSend(syncSend);
        message.setCreateBy(sourceAppId);
        if (message.isSyncSend()) {
            message.setSendTimes(1);
        }
        int r = roundIdx++;
        if (roundIdx >= al.length) {
            roundIdx = 0;
        }
        MessageSaveThread.addServerHitHis(message);
        if (!syncSend) {
            al[r].add(message);
        }
        return message.getMsgId();
    }

    public MessagePool(int nowIndex) {
        this.nowIndex = nowIndex;
        System.out.println("thread " + this.nowIndex + " started");
    }

    @Override
    public void run() {
        block6: while (true) {
            try {
                while (al[this.nowIndex].size() > 0) {
                    int status;
                    Message message;
                    block16: {
                        message = (Message)al[this.nowIndex].get(0);
                        status = 1;
                        try {
                            String result;
                            if (message.getToSendTimeMills() > System.currentTimeMillis()) {
                                al[this.nowIndex].remove(0);
                                al[this.nowIndex].add(message);
                                Thread.sleep(1000L);
                                continue block6;
                            }
                            if (AppKeyService.isDebug()) {
                                System.out.println("starting push:" + message.getAppId() + ",type=" + message.getOriParamMap().get("type"));
                            }
                            al[this.nowIndex].remove(0);
                            if (!UrlCheck.isUrlCanUse(message.getUrl())) {
                                status = 2;
                                result = "\u5931\u8d25\u6b21\u6570\u8fc7\u591a\uff0c\u5df2\u505c\u6b62\u63a8\u9001\uff08\u7b49url\u6062\u590d\u4e4b\u540e\uff0c\u4f1a\u81ea\u52a8\u6062\u590d\u901a\u8baf\uff09";
                                message.setResult(result);
                            } else {
                                if (1 != message.getStatus() && message.getSendTimes() < AppKeyService.tryTime) {
                                    result = null;
                                    result = SignAndPost.pushMsg(message.getEncryptType(), message.getUrl(), message.getAppId(), message.getSecret(), message.getOriParamMap(), message.getCreateBy());
                                    message.setSendTimes(message.getSendTimes() + 1);
                                    if (result.length() > 250) {
                                        result = result.substring(0, 250);
                                    }
                                    message.setResult(result);
                                    if (AppKeyService.isDebug) {
                                        System.out.println("thread " + this.nowIndex + ",push succes,msgId=" + message.getMsgId() + ", result=" + result);
                                    }
                                }
                                status = 1;
                            }
                        }
                        catch (Exception e) {
                            status = 2;
                            System.out.println("thread " + this.nowIndex + ",push fail,appId=" + message.getAppId() + ",message.getUrl()=" + message.getUrl() + ",params=" + message.getOriParamMap());
                            e.printStackTrace();
                            if (message.getSendTimes() >= AppKeyService.tryTime) break block16;
                            ByteArrayOutputStream buf = new ByteArrayOutputStream();
                            e.printStackTrace(new PrintWriter(buf, true));
                            String expMessage = buf.toString();
                            if (expMessage.length() > 250) {
                                expMessage = expMessage.substring(0, 250);
                            }
                            message.setSyncSend(false);
                            message.setResult(expMessage);
                            message.setToSendTimeMills(System.currentTimeMillis() + (long)(message.getSendTimes() * 5 * 60000));
                            message.setSendTimes(message.getSendTimes() + 1);
                            al[this.nowIndex].add(message);
                        }
                    }
                    message.setStatus(status);
                    MessageSaveThread.addServerHitHis(message);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalIp() {
        String ip = "";
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            block6: while (true) {
                if (!netInterfaces.hasMoreElements()) {
                    return String.valueOf(ip) + ",V=" + AppKeyService.version;
                }
                try {
                    NetworkInterface ni = netInterfaces.nextElement();
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    if (ni.isLoopback() || ni.isVirtual() || !ni.isUp()) continue;
                    while (true) {
                        if (!ips.hasMoreElements()) continue block6;
                        try {
                            InetAddress ia = ips.nextElement();
                            if (ia == null || !(ia instanceof Inet4Address)) continue;
                            if (ip.equals("")) {
                                ip = ia.getHostAddress();
                                continue;
                            }
                            ip = String.valueOf(ip) + "," + ia.getHostAddress();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception ni) {
                    // empty catch block
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(ip) + ",V=" + AppKeyService.version;
    }
}

