/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.GeoHashUtils;
import org.apache.lucene.util.GeoUtils;

public final class GeoPoint {
    private double lat;
    private double lon;

    public GeoPoint() {
    }

    public GeoPoint(String value) {
        this.resetFromString(value);
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    public GeoPoint reset(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoPoint resetLat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoPoint resetLon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoPoint resetFromString(String value) {
        int comma = value.indexOf(44);
        if (comma != -1) {
            this.lat = Double.parseDouble(value.substring(0, comma).trim());
            this.lon = Double.parseDouble(value.substring(comma + 1).trim());
        } else {
            this.resetFromGeoHash(value);
        }
        return this;
    }

    public GeoPoint resetFromIndexHash(long hash) {
        this.lon = GeoUtils.mortonUnhashLon((long)hash);
        this.lat = GeoUtils.mortonUnhashLat((long)hash);
        return this;
    }

    public GeoPoint resetFromGeoHash(String geohash) {
        long hash = GeoHashUtils.mortonEncode((String)geohash);
        return this.reset(GeoUtils.mortonUnhashLat((long)hash), GeoUtils.mortonUnhashLon((long)hash));
    }

    public GeoPoint resetFromGeoHash(long geohashLong) {
        int level = (int)(12L - (geohashLong & 0xFL));
        return this.resetFromIndexHash(BitUtil.flipFlop((long)(geohashLong >>> 4 << level * 5 + 2)));
    }

    public final double lat() {
        return this.lat;
    }

    public final double getLat() {
        return this.lat;
    }

    public final double lon() {
        return this.lon;
    }

    public final double getLon() {
        return this.lon;
    }

    public final String geohash() {
        return GeoHashUtils.stringEncode((double)this.lon, (double)this.lat);
    }

    public final String getGeohash() {
        return GeoHashUtils.stringEncode((double)this.lon, (double)this.lat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        if (Double.compare(geoPoint.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(geoPoint.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return this.lat + "," + this.lon;
    }

    public static GeoPoint parseFromLatLon(String latLon) {
        GeoPoint point = new GeoPoint();
        point.resetFromString(latLon);
        return point;
    }

    public static GeoPoint fromGeohash(String geohash) {
        return new GeoPoint().resetFromGeoHash(geohash);
    }

    public static GeoPoint fromGeohash(long geohashLong) {
        return new GeoPoint().resetFromGeoHash(geohashLong);
    }

    public static GeoPoint fromIndexLong(long indexLong) {
        return new GeoPoint().resetFromIndexHash(indexLong);
    }
}

