/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.joda.time.DateTimeZone;

public class RangeQueryParser
implements QueryParser {
    public static final String NAME = "range";
    private static final ParseField FIELDDATA_FIELD = new ParseField("fielddata", new String[0]).withAllDeprecated("[no replacement]");
    private static final ParseField NAME_FIELD = new ParseField("_name", new String[0]).withAllDeprecated("query name is not supported in short version of range query");

    @Inject
    public RangeQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        Object from = null;
        Object to = null;
        boolean includeLower = true;
        boolean includeUpper = true;
        DateTimeZone timeZone = null;
        DateMathParser forcedDateParser = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("from".equals(currentFieldName)) {
                        from = parser.objectBytes();
                        continue;
                    }
                    if ("to".equals(currentFieldName)) {
                        to = parser.objectBytes();
                        continue;
                    }
                    if ("include_lower".equals(currentFieldName) || "includeLower".equals(currentFieldName)) {
                        includeLower = parser.booleanValue();
                        continue;
                    }
                    if ("include_upper".equals(currentFieldName) || "includeUpper".equals(currentFieldName)) {
                        includeUpper = parser.booleanValue();
                        continue;
                    }
                    if ("boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if ("gt".equals(currentFieldName)) {
                        from = parser.objectBytes();
                        includeLower = false;
                        continue;
                    }
                    if ("gte".equals(currentFieldName) || "ge".equals(currentFieldName)) {
                        from = parser.objectBytes();
                        includeLower = true;
                        continue;
                    }
                    if ("lt".equals(currentFieldName)) {
                        to = parser.objectBytes();
                        includeUpper = false;
                        continue;
                    }
                    if ("lte".equals(currentFieldName) || "le".equals(currentFieldName)) {
                        to = parser.objectBytes();
                        includeUpper = true;
                        continue;
                    }
                    if ("time_zone".equals(currentFieldName) || "timeZone".equals(currentFieldName)) {
                        timeZone = DateTimeZone.forID((String)parser.text());
                        continue;
                    }
                    if ("format".equals(currentFieldName)) {
                        forcedDateParser = new DateMathParser(Joda.forPattern(parser.text()));
                        continue;
                    }
                    if ("_name".equals(currentFieldName)) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[range] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (parseContext.parseFieldMatcher().match(currentFieldName, NAME_FIELD)) {
                queryName = parser.text();
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, FIELDDATA_FIELD)) continue;
            throw new QueryParsingException(parseContext, "[range] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        Query query = null;
        MappedFieldType mapper = parseContext.fieldMapper(fieldName);
        if (mapper != null) {
            if (mapper instanceof DateFieldMapper.DateFieldType) {
                query = ((DateFieldMapper.DateFieldType)mapper).rangeQuery(from, to, includeLower, includeUpper, timeZone, forcedDateParser);
            } else {
                if (timeZone != null) {
                    throw new QueryParsingException(parseContext, "[range] time_zone can not be applied to non date field [" + fieldName + "]", new Object[0]);
                }
                query = mapper.rangeQuery(from, to, includeLower, includeUpper);
            }
        }
        if (query == null) {
            query = new TermRangeQuery(fieldName, BytesRefs.toBytesRef(from), BytesRefs.toBytesRef(to), includeLower, includeUpper);
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

