/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.chart;

import common.Assert;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.biff.IntegerHelper;
import jxl.read.biff.File;
import jxl.read.biff.MsoDrawingRecord;
import jxl.read.biff.ObjRecord;

public class Chart
implements ByteData {
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private int startpos;
    private int endpos;
    private File file;
    private WorkbookSettings workbookSettings;

    public Chart(MsoDrawingRecord mso, ObjRecord obj, int sp, int ep, File f, WorkbookSettings ws) {
        this.msoDrawingRecord = mso;
        this.objRecord = obj;
        this.startpos = sp;
        this.endpos = ep;
        this.file = f;
        this.workbookSettings = ws;
        Assert.verify(this.msoDrawingRecord != null);
        Assert.verify(this.objRecord != null);
    }

    public byte[] getBytes() {
        byte[] msodata = this.msoDrawingRecord.getRecord().getData();
        byte[] objdata = this.objRecord.getRecord().getData();
        byte[] chartdata = this.file.read(this.startpos, this.endpos - this.startpos);
        byte[] data = new byte[msodata.length + 4 + objdata.length + 4 + chartdata.length];
        int pos = 0;
        IntegerHelper.getTwoBytes(this.msoDrawingRecord.getRecord().getCode(), data, pos);
        IntegerHelper.getTwoBytes(this.msoDrawingRecord.getRecord().getLength(), data, pos + 2);
        System.arraycopy(msodata, 0, data, pos + 4, msodata.length);
        IntegerHelper.getTwoBytes(this.objRecord.getRecord().getCode(), data, pos += msodata.length + 4);
        IntegerHelper.getTwoBytes(this.objRecord.getRecord().getLength(), data, pos + 2);
        System.arraycopy(objdata, 0, data, pos + 4, objdata.length);
        System.arraycopy(chartdata, 0, data, pos += objdata.length + 4, chartdata.length);
        chartdata = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
        return data;
    }
}

