/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class BinaryDoubleBinder
extends Binder {
    Binder theBinaryDoubleCopyingBinder = OraclePreparedStatementReadOnly.theStaticBinaryDoubleCopyingBinder;

    static void init(Binder x) {
        x.type = (short)101;
        x.bytelen = 8;
    }

    BinaryDoubleBinder() {
        BinaryDoubleBinder.init(this);
    }

    Binder copyingBinder() {
        return this.theBinaryDoubleCopyingBinder;
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        byte[] b = bindBytes;
        int offset = byteoffset;
        double val = stmt.parameterDouble[rank][bindPosition];
        if (val == 0.0) {
            val = 0.0;
        } else if (val != val) {
            val = Double.NaN;
        }
        long longBits = Double.doubleToLongBits(val);
        int lowInt = (int)longBits;
        int highInt = (int)(longBits >> 32);
        int b7 = lowInt;
        int b6 = lowInt >>= 8;
        int b5 = lowInt >>= 8;
        int b4 = lowInt >>= 8;
        int b3 = highInt;
        int b2 = highInt >>= 8;
        int b1 = highInt >>= 8;
        int b0 = highInt >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b2 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
            b4 ^= 0xFFFFFFFF;
            b5 ^= 0xFFFFFFFF;
            b6 ^= 0xFFFFFFFF;
            b7 ^= 0xFFFFFFFF;
        }
        b[offset + 7] = (byte)b7;
        b[offset + 6] = (byte)b6;
        b[offset + 5] = (byte)b5;
        b[offset + 4] = (byte)b4;
        b[offset + 3] = (byte)b3;
        b[offset + 2] = (byte)b2;
        b[offset + 1] = (byte)b1;
        b[offset] = (byte)b0;
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = 8;
    }
}

