/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumBinder;

class FloatBinder
extends VarnumBinder {
    FloatBinder() {
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) throws SQLException {
        byte[] b = bindBytes;
        int offset = byteoffset + 1;
        double val = stmt.parameterDouble[rank][bindPosition];
        int len = 0;
        if (val == 0.0) {
            b[offset] = -128;
            len = 1;
        } else if (val == Double.POSITIVE_INFINITY) {
            b[offset] = -1;
            b[offset + 1] = 101;
            len = 2;
        } else if (val == Double.NEGATIVE_INFINITY) {
            b[offset] = 0;
            len = 1;
        } else {
            long bits;
            int rawExponent;
            int guess;
            boolean neg;
            boolean bl = neg = val < 0.0;
            if (neg) {
                val = -val;
            }
            if ((guess = ((rawExponent = (int)((bits = Double.doubleToLongBits(val)) >> 52 & 0x7FFL)) > 1023 ? 126 : 127) - (int)((double)(rawExponent - 1023) / 6.643856189774725)) < 0) {
                SQLException ex = new SQLException(CoreException.getMessage((byte)3) + " trying to bind " + val);
                throw ex;
            }
            if (guess > 192) {
                SQLException ex = new SQLException(CoreException.getMessage((byte)2) + " trying to bind " + val);
                throw ex;
            }
            if (val > factorTable[guess]) {
                while (guess > 0 && val > factorTable[--guess]) {
                }
            } else {
                while (guess < 193 && val <= factorTable[guess + 1]) {
                    ++guess;
                }
            }
            if (val == factorTable[guess]) {
                if (guess < 65) {
                    SQLException ex = new SQLException(CoreException.getMessage((byte)3) + " trying to bind " + val);
                    throw ex;
                }
                if (guess > 192) {
                    SQLException ex = new SQLException(CoreException.getMessage((byte)2) + " trying to bind " + val);
                    throw ex;
                }
                if (neg) {
                    b[offset] = (byte)(62 - (127 - guess));
                    b[offset + 1] = 100;
                    b[offset + 2] = 102;
                    len = 3;
                } else {
                    b[offset] = (byte)(192 + (128 - guess));
                    b[offset + 1] = 2;
                    len = 2;
                }
            } else {
                int nSignificantBits;
                if (guess < 64) {
                    SQLException ex = new SQLException(CoreException.getMessage((byte)3) + " trying to bind " + val);
                    throw ex;
                }
                if (guess > 191) {
                    SQLException ex = new SQLException(CoreException.getMessage((byte)2) + " trying to bind " + val);
                    throw ex;
                }
                int fBits = Float.floatToIntBits((float)val);
                int fractBits = fBits & 0x7FFFFF;
                int binExp = fBits >> 23 & 0xFF;
                char[] digits = stmt.digits;
                if (binExp == 0) {
                    while ((long)(fractBits & 0x800000) == 0L) {
                        fractBits <<= 1;
                        --binExp;
                    }
                    nSignificantBits = 24 + binExp;
                    ++binExp;
                } else {
                    fractBits |= 0x800000;
                    nSignificantBits = 24;
                }
                len = this.dtoa(b, offset, val, neg, true, digits, binExp -= 127, (long)fractBits << 29, nSignificantBits);
            }
        }
        b[byteoffset] = (byte)len;
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)(len + 1);
    }
}

