/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T2CConnection;

class T2CResultSetAccessor
extends ResultSetAccessor {
    T2CResultSetAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(stmt, max_len * 2, form, external_type, forBind);
    }

    T2CResultSetAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        super(stmt, max_len * 2, nullable, flags, precision, scale, contflag, total_elems, form);
    }

    byte[] getBytes(int currentRow) throws SQLException {
        byte[] result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            byte align = ((T2CConnection)this.statement.connection).byteAlign;
            int adjusted_columnIndex = this.columnIndex + (align - 1) & ~(align - 1);
            int off = adjusted_columnIndex + len * currentRow;
            result = new byte[len];
            System.arraycopy(this.rowSpaceByte, off, result, 0, len);
        }
        return result;
    }
}

