/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIMsg;

class T4C8TTILobd
extends T4CTTIMsg {
    static final int LOBD_STATE0 = 0;
    static final int LOBD_STATE1 = 1;
    static final int LOBD_STATE2 = 2;
    static final int LOBD_STATE3 = 3;
    static final int LOBD_STATE_EXIT = 4;
    static final short TTCG_LNG = 254;
    static final short LOBDATALENGTH = 252;
    static byte[] ucs2Char = new byte[2];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:53_PDT_2005";

    T4C8TTILobd(T4CMAREngine mengine) {
        super((byte)14);
        this.setMarshalingEngine(mengine);
    }

    void marshalLobData(byte[] inBuffer, long inBufferOffset, long numBytes) throws SQLException, IOException {
        long length = numBytes;
        boolean ttcgLong = false;
        this.marshalTTCcode();
        if (length > 252L) {
            ttcgLong = true;
            this.meg.marshalUB1((short)254);
        }
        long count = 0L;
        while (length > 252L) {
            this.meg.marshalUB1((short)252);
            this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 252L), 252);
            ++count;
            length -= 252L;
        }
        if (length > 0L) {
            this.meg.marshalUB1((short)length);
            this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 252L), (int)length);
        }
        if (ttcgLong) {
            this.meg.marshalUB1((short)0);
        }
    }

    void marshalLobDataUB2(byte[] inBuffer, long inBufferOffset, long numChars) throws SQLException, IOException {
        long numUB2 = numChars;
        boolean ttcgLong = false;
        this.marshalTTCcode();
        if (numUB2 > 84L) {
            ttcgLong = true;
            this.meg.marshalUB1((short)254);
        }
        long count = 0L;
        while (numUB2 > 84L) {
            this.meg.marshalUB1((short)252);
            for (int j = 0; j < 84; ++j) {
                this.meg.marshalUB1((short)2);
                this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 168L + (long)(j * 2)), 2);
            }
            ++count;
            numUB2 -= 84L;
        }
        if (numUB2 > 0L) {
            long length = numUB2 * 3L;
            this.meg.marshalUB1((short)length);
            int j = 0;
            while ((long)j < numUB2) {
                this.meg.marshalUB1((short)2);
                this.meg.marshalB1Array(inBuffer, (int)(inBufferOffset + count * 168L + (long)(j * 2)), 2);
                ++j;
            }
        }
        if (ttcgLong) {
            this.meg.marshalUB1((short)0);
        }
    }

    long unmarshalLobData(byte[] outBuffer) throws SQLException, IOException {
        long bytesRead = 0L;
        long offset = 0L;
        short length = 0;
        int state = 0;
        block6: while (state != 4) {
            switch (state) {
                case 0: {
                    length = this.meg.unmarshalUB1();
                    if (length == 254) {
                        state = 2;
                        continue block6;
                    }
                    state = 1;
                    continue block6;
                }
                case 1: {
                    this.meg.getNBytes(outBuffer, (int)offset, length);
                    bytesRead += (long)length;
                    state = 4;
                    continue block6;
                }
                case 2: {
                    length = this.meg.unmarshalUB1();
                    if (length > 0) {
                        state = 3;
                        continue block6;
                    }
                    state = 4;
                    continue block6;
                }
                case 3: {
                    this.meg.getNBytes(outBuffer, (int)offset, length);
                    bytesRead += (long)length;
                    offset += (long)length;
                    state = 2;
                    continue block6;
                }
            }
        }
        return bytesRead;
    }

    long unmarshalClobUB2(byte[] outBuffer) throws SQLException, IOException {
        long bytesRead = 0L;
        long offset = 0L;
        int length = 0;
        int i = 0;
        int numBytes = 0;
        int state = 0;
        block6: while (state != 4) {
            switch (state) {
                case 0: {
                    length = this.meg.unmarshalUB1();
                    if (length == 254) {
                        state = 2;
                        continue block6;
                    }
                    state = 1;
                    continue block6;
                }
                case 1: {
                    i = 0;
                    while (i < length) {
                        numBytes = this.meg.unmarshalUCS2(outBuffer, offset);
                        i += numBytes;
                        offset += 2L;
                    }
                    bytesRead += (long)length;
                    state = 4;
                    continue block6;
                }
                case 2: {
                    length = this.meg.unmarshalUB1();
                    if (length > 0) {
                        state = 3;
                        continue block6;
                    }
                    state = 4;
                    continue block6;
                }
                case 3: {
                    i = 0;
                    while (i < length) {
                        numBytes = this.meg.unmarshalUCS2(outBuffer, offset);
                        i += numBytes;
                        offset += 2L;
                    }
                    bytesRead += (long)length;
                    state = 2;
                    continue block6;
                }
            }
        }
        return bytesRead;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4C8TTILobd"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

