/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class OracleTypeNUMBER
extends OracleType
implements Serializable {
    static final long serialVersionUID = -7182242886677299812L;
    int precision;
    int scale;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:49_PDT_2005";

    protected OracleTypeNUMBER() {
    }

    protected OracleTypeNUMBER(int typecode) {
        super(typecode);
    }

    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(value, conn);
    }

    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(obj, conn, beginIdx, count);
    }

    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.parseTDSrec( tdsReader = " + tdsReader + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.nullOffset = tdsReader.nullOffset++;
        this.ldsOffset = tdsReader.ldsOffset++;
        this.precision = tdsReader.readUnsignedByte();
        this.scale = tdsReader.readByte();
    }

    public int getSizeLDS(byte[] FDO) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.getSizeLDS( FDO = " + FDO + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(FDO, 12);
            this.alignForLds = Util.fdoGetAlign(FDO, 12);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.getSizeLDS:return " + this.sizeForLds, this);
            OracleLog.recursiveTrace = false;
        }
        return this.sizeForLds;
    }

    public int getAlignLDS(byte[] FDO) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.getAlignLDS( FDO = " + FDO + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(FDO, 12);
            this.alignForLds = Util.fdoGetAlign(FDO, 12);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.getAlignLDS:return " + this.alignForLds, this);
            OracleLog.recursiveTrace = false;
        }
        return this.alignForLds;
    }

    protected Object unpickle80rec(UnpickleContext context, int format, int type, Map map) throws SQLException {
        return OracleTypeNUMBER.numericUnpickle80rec(this.ldsOffset, this.nullOffset, context, format, type, map);
    }

    protected static Object numericUnpickle80rec(int lds_offset, int null_offset, UnpickleContext context, int format, int style, Map map) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.numericUnpickle80rec( lds_offset = " + lds_offset + ", null_offset =" + null_offset + ", context =" + context + ", format = " + format + ", style = " + style + ", map = " + map + ")");
            OracleLog.recursiveTrace = false;
        }
        switch (format) {
            case 1: {
                if (context.isNull(null_offset)) {
                    return null;
                }
                context.skipTo(context.ldsOffsets[lds_offset]);
                break;
            }
            case 2: {
                if ((context.readByte() & 1) != 1) break;
                context.skipBytes(22);
                return null;
            }
            case 3: {
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "format=" + format);
            }
        }
        if (style == 9) {
            context.skipBytes(22);
            return null;
        }
        return OracleTypeNUMBER.toNumericObject(context.readVarNumBytes(), style, map);
    }

    protected static Object unpickle80NativeArray(UnpickleContext context, long beginIdx, int size, int style, int format) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.unpickle80_nativeArray( context =" + context + ", begin index =" + beginIdx + ", size = " + size + ", style = " + style + ", format = " + format + ")");
            OracleLog.recursiveTrace = false;
        }
        int numSz = 0;
        switch (format) {
            case 2: {
                numSz = 23;
                break;
            }
            case 3: {
                numSz = 22;
                break;
            }
            default: {
                DatabaseError.throwSqlException(1, "format=" + format);
            }
        }
        if (size > 0) {
            context.skipBytes(numSz * ((int)beginIdx - 1));
        }
        int offset = context.absoluteOffset();
        byte[] data = context.image();
        int current = 0;
        switch (style) {
            case 4: {
                int[] holder = new int[size];
                for (int i = 0; i < size; ++i) {
                    current = offset + i * numSz;
                    if (format != 3 && (data[current++] & 1) != 0) continue;
                    byte[] array = new byte[data[current++]];
                    System.arraycopy(data, current, array, 0, array.length);
                    holder[i] = NUMBER.toInt(array);
                }
                context.skipBytes(numSz * size);
                return holder;
            }
            case 5: {
                double[] holder = new double[size];
                for (int i = 0; i < size; ++i) {
                    current = offset + i * numSz;
                    if (format != 3 && (data[current++] & 1) != 0) continue;
                    byte[] array = new byte[data[current++]];
                    System.arraycopy(data, current, array, 0, array.length);
                    holder[i] = NUMBER.toDouble(array);
                }
                context.skipBytes(numSz * size);
                return holder;
            }
            case 7: {
                long[] holder = new long[size];
                for (int i = 0; i < size; ++i) {
                    current = offset + i * numSz;
                    if (format != 3 && (data[current++] & 1) != 0) continue;
                    byte[] array = new byte[data[current++]];
                    System.arraycopy(data, current, array, 0, array.length);
                    holder[i] = NUMBER.toLong(array);
                }
                context.skipBytes(numSz * size);
                return holder;
            }
            case 6: {
                float[] holder = new float[size];
                for (int i = 0; i < size; ++i) {
                    current = offset + i * numSz;
                    if (format != 3 && (data[current++] & 1) != 0) continue;
                    byte[] array = new byte[data[current++]];
                    System.arraycopy(data, current, array, 0, array.length);
                    holder[i] = NUMBER.toFloat(array);
                }
                context.skipBytes(numSz * size);
                return holder;
            }
            case 8: {
                short[] holder = new short[size];
                for (int i = 0; i < size; ++i) {
                    current = offset + i * numSz;
                    if (format != 3 && (data[current++] & 1) != 0) continue;
                    byte[] array = new byte[data[current++]];
                    System.arraycopy(data, current, array, 0, array.length);
                    holder[i] = NUMBER.toShort(array);
                }
                context.skipBytes(numSz * size);
                return holder;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    protected static Object unpickle81NativeArray(PickleContext context, long beginIdx, int size, int style) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.unpickle81_nativeArray( context =" + context + ", begin index =" + beginIdx + ", size = " + size + ", style = " + style + ")");
            OracleLog.recursiveTrace = false;
        }
        int i = 1;
        while ((long)i < beginIdx && size > 0) {
            context.skipDataValue();
            ++i;
        }
        byte[] val = null;
        switch (style) {
            case 4: {
                int[] holder = new int[size];
                for (int i2 = 0; i2 < size; ++i2) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i2] = NUMBER.toInt(val);
                }
                return holder;
            }
            case 5: {
                double[] holder = new double[size];
                for (int i3 = 0; i3 < size; ++i3) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i3] = NUMBER.toDouble(val);
                }
                return holder;
            }
            case 7: {
                long[] holder = new long[size];
                for (int i4 = 0; i4 < size; ++i4) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i4] = NUMBER.toLong(val);
                }
                return holder;
            }
            case 6: {
                float[] holder = new float[size];
                for (int i5 = 0; i5 < size; ++i5) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i5] = NUMBER.toFloat(val);
                }
                return holder;
            }
            case 8: {
                short[] holder = new short[size];
                for (int i6 = 0; i6 < size; ++i6) {
                    val = context.readDataValue();
                    if (val == null) continue;
                    holder[i6] = NUMBER.toShort(val);
                }
                return holder;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    protected Object toObject(byte[] bytes, int style, Map map) throws SQLException {
        return OracleTypeNUMBER.toNumericObject(bytes, style, map);
    }

    static Object toNumericObject(byte[] bytes, int style, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        switch (style) {
            case 1: {
                return new NUMBER(bytes);
            }
            case 2: {
                return NUMBER.toBigDecimal(bytes);
            }
            case 3: {
                return bytes;
            }
        }
        DatabaseError.throwSqlException(23);
        return null;
    }

    public static NUMBER toNUMBER(Object value, OracleConnection conn) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.toNUMBER( object = " + value + ", connection = " + conn + ")");
            OracleLog.recursiveTrace = false;
        }
        NUMBER datum = null;
        if (value != null) {
            try {
                datum = value instanceof NUMBER ? (NUMBER)value : new NUMBER(value);
            }
            catch (SQLException e) {
                DatabaseError.throwSqlException(59, value);
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.toNUMBER:return " + datum);
            OracleLog.recursiveTrace = false;
        }
        return datum;
    }

    public static Datum[] toNUMBERArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.toNUMBERArray( object = " + obj + ", connection = " + conn + ", begin index = " + beginIdx + ", count = " + count + ")");
            OracleLog.recursiveTrace = false;
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof Object[] && !(obj instanceof char[][])) {
                Object[] objArray = (Object[])obj;
                int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                for (int i = 0; i < length; ++i) {
                    datumArray[i] = OracleTypeNUMBER.toNUMBER(objArray[(int)beginIdx + i - 1], conn);
                }
            } else {
                datumArray = OracleTypeNUMBER.cArrayToNUMBERArray(obj, conn, beginIdx, count);
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.toNUMBERArray:return " + datumArray);
            OracleLog.recursiveTrace = false;
        }
        return datumArray;
    }

    static Datum[] cArrayToNUMBERArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.cArrayToNUMBERArray( object = " + obj + ", connection = " + conn + ", begin index = " + beginIdx + ", count = " + count + ")");
            OracleLog.recursiveTrace = false;
        }
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof short[]) {
                short[] parray = (short[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof int[]) {
                int[] parray = (int[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof long[]) {
                long[] parray = (long[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof float[]) {
                float[] parray = (float[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof double[]) {
                double[] parray = (double[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(parray[(int)beginIdx + i - 1]);
                }
            } else if (obj instanceof boolean[]) {
                boolean[] parray = (boolean[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(new Boolean(parray[(int)beginIdx + i - 1]));
                }
            } else if (obj instanceof char[][]) {
                char[][] parray = (char[][])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new NUMBER(new String(parray[(int)beginIdx + i - 1]));
                }
            } else {
                DatabaseError.throwSqlException(59, obj);
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINEST, "OracleTypeNUMBER.cArrayToNUMBERArray:return " + datumArray);
            OracleLog.recursiveTrace = false;
        }
        return datumArray;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINER, "OracleTypeNUMBER.writeObject()", this);
            OracleLog.recursiveTrace = false;
        }
        out.writeInt(this.scale);
        out.writeInt(this.precision);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.adtLogger.log(Level.FINER, "OracleTypeNUMBER.readObject()", this);
            OracleLog.recursiveTrace = false;
        }
        this.scale = in.readInt();
        this.precision = in.readInt();
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeNUMBER"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

