/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.Joinable;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleJDBCRowSet;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleJoinRowSet
extends OracleWebRowSet
implements JoinRowSet {
    private static final String MATCH_COLUMN_SUFFIX = "#MATCH_COLUMN";
    private static boolean[] supportedJoins = new boolean[]{false, true, false, false, false};
    private int joinType = 1;
    private Vector addedRowSets = new Vector();
    private Vector addedRowSetNames = new Vector();
    private Object lockForJoinActions;

    public synchronized void addRowSet(Joinable rowSet) throws SQLException {
        if (rowSet == null) {
            throw new SQLException("Invalid empty RowSet parameter");
        }
        if (!(rowSet instanceof RowSet)) {
            throw new SQLException("The parameter is not a RowSet instance");
        }
        OracleCachedRowSet addedRowSet = this.checkAndWrapRowSet((RowSet)((Object)rowSet));
        String tblName = this.getMatchColumnTableName((RowSet)((Object)rowSet));
        switch (this.joinType) {
            case 1: {
                this.doInnerJoin(addedRowSet);
                this.addedRowSets.add(rowSet);
                this.addedRowSetNames.add(tblName);
                break;
            }
            default: {
                throw new SQLException("Join type is not supported");
            }
        }
    }

    public synchronized void addRowSet(RowSet rowSet, int matchColumnIndex) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(matchColumnIndex);
        this.addRowSet((Joinable)((Object)rowSet));
    }

    public synchronized void addRowSet(RowSet rowSet, String matchColumnName) throws SQLException {
        ((OracleRowSet)((Object)rowSet)).setMatchColumn(matchColumnName);
        this.addRowSet((Joinable)((Object)rowSet));
    }

    public synchronized void addRowSet(RowSet[] rowSets, int[] matchColumnIndexes) throws SQLException {
        if (rowSets.length != matchColumnIndexes.length) {
            throw new SQLException("Number of elements in rowsets is not equal to match columns");
        }
        for (int i = 0; i < rowSets.length; ++i) {
            ((OracleRowSet)((Object)rowSets[i])).setMatchColumn(matchColumnIndexes[i]);
            this.addRowSet((Joinable)((Object)rowSets[i]));
        }
    }

    public synchronized void addRowSet(RowSet[] rowSets, String[] matchColumnNames) throws SQLException {
        if (rowSets.length != matchColumnNames.length) {
            throw new SQLException("Number of elements in rowsets is not equal to match columns");
        }
        for (int i = 0; i < rowSets.length; ++i) {
            ((OracleRowSet)((Object)rowSets[i])).setMatchColumn(matchColumnNames[i]);
            this.addRowSet((Joinable)((Object)rowSets[i]));
        }
    }

    public Collection getRowSets() throws SQLException {
        return this.addedRowSets;
    }

    public String[] getRowSetNames() throws SQLException {
        Object[] objs = this.addedRowSetNames.toArray();
        String[] names = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            names[i] = (String)objs[i];
        }
        return names;
    }

    public CachedRowSet toCachedRowSet() throws SQLException {
        OracleCachedRowSet ocrs = (OracleCachedRowSet)this.createCopy();
        ocrs.setCommand("");
        return ocrs;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public boolean supportsCrossJoin() {
        return supportedJoins[0];
    }

    public boolean supportsInnerJoin() {
        return supportedJoins[1];
    }

    public boolean supportsLeftOuterJoin() {
        return supportedJoins[2];
    }

    public boolean supportsRightOuterJoin() {
        return supportedJoins[3];
    }

    public boolean supportsFullJoin() {
        return supportedJoins[4];
    }

    public void setJoinType(int jtype) throws SQLException {
        if (jtype != 1) {
            throw new SQLException("Join type is not supported");
        }
        this.joinType = jtype;
    }

    public synchronized String getWhereClause() throws SQLException {
        if (this.addedRowSets.size() < 2) {
            return "WHERE";
        }
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("WHERE\n");
        OracleRowSet leftRowSet = (OracleRowSet)this.addedRowSets.get(0);
        int[] matchIndexesLeft = leftRowSet.getMatchColumnIndexes();
        ResultSetMetaData leftMd = leftRowSet.getMetaData();
        String leftTable = leftRowSet.getTableName();
        for (int i = 1; i < this.addedRowSets.size(); ++i) {
            if (i > 1) {
                whereClause.append("\nAND\n");
            }
            OracleRowSet rightRowSet = (OracleRowSet)this.addedRowSets.get(i);
            int[] matchIndexesRight = rightRowSet.getMatchColumnIndexes();
            ResultSetMetaData rightMd = rightRowSet.getMetaData();
            String rightTable = rightRowSet.getTableName();
            for (int j = 0; j < matchIndexesLeft.length; ++j) {
                if (j > 0) {
                    whereClause.append("\nAND\n");
                }
                whereClause.append("(" + leftTable + "." + leftMd.getColumnName(matchIndexesLeft[j]) + " = " + rightTable + "." + rightMd.getColumnName(matchIndexesRight[j]) + ")");
            }
            leftRowSet = rightRowSet;
            matchIndexesLeft = matchIndexesRight;
            leftMd = rightMd;
            leftTable = rightTable;
        }
        whereClause.append(";");
        return whereClause.toString();
    }

    private void doInnerJoin(OracleCachedRowSet addedRowSet) throws SQLException {
        if (this.addedRowSets.isEmpty()) {
            this.setMetaData((RowSetMetaData)addedRowSet.getMetaData());
            this.populate(addedRowSet);
            this.setMatchColumn(addedRowSet.getMatchColumnIndexes());
        } else {
            boolean isMatchColumn;
            Vector<OracleRow> newRows = new Vector<OracleRow>(100);
            OracleRowSetMetaData newMd = new OracleRowSetMetaData(10);
            int[] matchIndexesLeft = this.getMatchColumnIndexes();
            int[] matchIndexesRight = addedRowSet.getMatchColumnIndexes();
            int newColCount = this.getMetaData().getColumnCount() + addedRowSet.getMetaData().getColumnCount() - matchIndexesRight.length;
            newMd.setColumnCount(newColCount);
            String tableNameForMatchColumn = this.getTableName() + "#" + addedRowSet.getTableName();
            for (int indexLeft = 1; indexLeft <= this.colCount; ++indexLeft) {
                isMatchColumn = false;
                for (int j = 0; j < matchIndexesLeft.length; ++j) {
                    if (indexLeft != matchIndexesLeft[j]) continue;
                    isMatchColumn = true;
                    break;
                }
                this.setNewColumnMetaData(indexLeft, newMd, indexLeft, (RowSetMetaData)this.rowsetMetaData, isMatchColumn, tableNameForMatchColumn);
            }
            RowSetMetaData addedRowSetMd = (RowSetMetaData)addedRowSet.getMetaData();
            int addedRowSetColCount = addedRowSetMd.getColumnCount();
            int indexRightNew = this.colCount + 1;
            int[] indexesRightNew = new int[addedRowSetColCount];
            for (int indexRight = 1; indexRight <= addedRowSetColCount; ++indexRight) {
                isMatchColumn = false;
                for (int j = 0; j < matchIndexesRight.length; ++j) {
                    if (indexRight != matchIndexesLeft[j]) continue;
                    isMatchColumn = true;
                    break;
                }
                if (!isMatchColumn) {
                    this.setNewColumnMetaData(indexRightNew, newMd, indexRight, addedRowSetMd, isMatchColumn, tableNameForMatchColumn);
                    indexesRightNew[indexRight - 1] = indexRightNew++;
                    continue;
                }
                indexesRightNew[indexRight - 1] = -1;
            }
            this.beforeFirst();
            int addedRowSetRowCount = addedRowSet.size();
            boolean matchFound = false;
            for (int leftRow = 1; leftRow <= this.rowCount; ++leftRow) {
                this.next();
                addedRowSet.beforeFirst();
                for (int rightRow = 1; rightRow <= addedRowSetRowCount; ++rightRow) {
                    addedRowSet.next();
                    matchFound = true;
                    for (int i = 0; i < matchIndexesLeft.length; ++i) {
                        Object rightObj;
                        Object leftObj = this.getObject(matchIndexesLeft[i]);
                        if (leftObj.equals(rightObj = addedRowSet.getObject(matchIndexesRight[i]))) continue;
                        matchFound = false;
                        break;
                    }
                    if (!matchFound) continue;
                    OracleRow newRow = new OracleRow(newColCount, true);
                    for (int colLeft = 1; colLeft <= this.colCount; ++colLeft) {
                        newRow.updateObject(colLeft, this.getObject(colLeft));
                    }
                    for (int colRight = 1; colRight <= addedRowSetColCount; ++colRight) {
                        if (indexesRightNew[colRight - 1] == -1) continue;
                        newRow.updateObject(indexesRightNew[colRight - 1], addedRowSet.getObject(colRight));
                    }
                    newRows.add(newRow);
                }
            }
            this.rows = newRows;
            this.presentRow = 0;
            this.rowCount = this.rows.size();
            this.setMetaData(newMd);
        }
    }

    private void setNewColumnMetaData(int newColIndex, RowSetMetaData newMd, int origColIndex, RowSetMetaData origMd, boolean isMatchColumn, String tableNameForMatchColumn) throws SQLException {
        newMd.setAutoIncrement(newColIndex, origMd.isAutoIncrement(origColIndex));
        newMd.setCaseSensitive(newColIndex, origMd.isCaseSensitive(origColIndex));
        newMd.setCatalogName(newColIndex, origMd.getCatalogName(origColIndex));
        newMd.setColumnDisplaySize(newColIndex, origMd.getColumnDisplaySize(origColIndex));
        if (isMatchColumn) {
            newMd.setColumnName(newColIndex, origMd.getColumnName(newColIndex) + MATCH_COLUMN_SUFFIX);
        } else {
            newMd.setColumnName(newColIndex, origMd.getColumnName(origColIndex));
        }
        newMd.setColumnLabel(newColIndex, newMd.getColumnName(origColIndex));
        newMd.setColumnType(newColIndex, origMd.getColumnType(origColIndex));
        newMd.setColumnTypeName(newColIndex, origMd.getColumnTypeName(origColIndex));
        newMd.setCurrency(newColIndex, origMd.isCurrency(origColIndex));
        newMd.setNullable(newColIndex, origMd.isNullable(origColIndex));
        newMd.setPrecision(newColIndex, origMd.getPrecision(origColIndex));
        newMd.setScale(newColIndex, origMd.getScale(origColIndex));
        newMd.setSchemaName(newColIndex, origMd.getSchemaName(origColIndex));
        newMd.setSearchable(newColIndex, origMd.isSearchable(origColIndex));
        newMd.setSigned(newColIndex, origMd.isSigned(origColIndex));
        if (isMatchColumn) {
            newMd.setTableName(newColIndex, tableNameForMatchColumn);
        } else {
            newMd.setTableName(newColIndex, origMd.getTableName(origColIndex));
        }
    }

    /*
     * WARNING - void declaration
     */
    private OracleCachedRowSet checkAndWrapRowSet(RowSet rowSet) throws SQLException {
        void var2_2;
        OracleCachedRowSet ocrs;
        if (rowSet instanceof OracleCachedRowSet) {
            ocrs = (OracleCachedRowSet)rowSet;
        } else if (rowSet instanceof OracleJDBCRowSet) {
            ocrs = new OracleCachedRowSet();
            ocrs.populate(rowSet);
            int[] matchIndexes = ((OracleJDBCRowSet)rowSet).getMatchColumnIndexes();
            ocrs.setMatchColumn(matchIndexes);
        } else {
            throw new SQLException("Third-party RowSet Join not yet supported");
        }
        return var2_2;
    }

    private String getMatchColumnTableName(RowSet rowset) throws SQLException {
        String tblName = null;
        if (rowset instanceof OracleRowSet) {
            tblName = ((OracleRowSet)((Object)rowset)).getTableName();
        }
        return tblName;
    }
}

