/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverters;

class CharacterSetSJIS
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterSJIS";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static Class m_charConvSuperclass;

    CharacterSetSJIS(int oracleId, CharacterConverters charConverter) {
        super(oracleId, charConverter);
    }

    static CharacterSetSJIS getInstance(int oracleId, CharacterConverters charConverter) {
        if (charConverter.getGroupId() == 4) {
            return new CharacterSetSJIS(oracleId, charConverter);
        }
        return null;
    }

    int decode(CharacterWalker walker) throws SQLException {
        int c = walker.bytes[walker.next] & 0xFF;
        ++walker.next;
        if (c > 223 || c > 127 && c < 161) {
            if (walker.bytes.length > walker.next) {
                c = c << 8 | walker.bytes[walker.next];
                ++walker.next;
            } else {
                throw new SQLException("destination too small");
            }
        }
        return c;
    }

    void encode(CharacterBuffer buffer, int c) throws SQLException {
        int bytesToShift = 0;
        int bytesNeeded = 1;
        while (c >> bytesToShift != 0) {
            bytesToShift = (short)(bytesToShift + 8);
            bytesNeeded = (short)(bytesNeeded + 1);
        }
        CharacterSetSJIS.need(buffer, bytesNeeded);
        while (bytesToShift >= 0) {
            buffer.bytes[buffer.next++] = (byte)(c >> bytesToShift & 0xFF);
            bytesToShift = (short)(bytesToShift - 8);
        }
    }
}

