/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.StrutsStatics;
import org.apache.struts2.dispatcher.ActionContextCleanUp;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.StaticContentLoader;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.ng.filter.FilterHostConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDispatcher
implements StrutsStatics,
Filter {
    private Logger log;
    private ActionMapper actionMapper;
    private FilterConfig filterConfig;
    protected Dispatcher dispatcher;
    protected StaticContentLoader staticResourceLoader;
    private static ThreadLocal<Boolean> devModeOverride = new InheritableThreadLocal<Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.filterConfig = filterConfig;
            this.initLogging();
            this.dispatcher = this.createDispatcher(filterConfig);
            this.dispatcher.init();
            this.dispatcher.getContainer().inject((Object)this);
            this.staticResourceLoader.setHostConfig(new FilterHostConfig(filterConfig));
        }
        finally {
            ActionContext.setContext(null);
        }
    }

    private void initLogging() {
        String factoryName = this.filterConfig.getInitParameter("loggerFactory");
        if (factoryName != null) {
            try {
                Class cls = ClassLoaderUtil.loadClass((String)factoryName, this.getClass());
                LoggerFactory fac = (LoggerFactory)cls.newInstance();
                LoggerFactory.setLoggerFactory((LoggerFactory)fac);
            }
            catch (InstantiationException e) {
                System.err.println("Unable to instantiate logger factory: " + factoryName + ", using default");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.err.println("Unable to access logger factory: " + factoryName + ", using default");
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Unable to locate logger factory class: " + factoryName + ", using default");
                e.printStackTrace();
            }
        }
        this.log = LoggerFactory.getLogger(FilterDispatcher.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.dispatcher == null) {
            this.log.warn("something is seriously wrong, Dispatcher is not initialized (null) ", new String[0]);
        } else {
            try {
                this.dispatcher.cleanup();
            }
            finally {
                ActionContext.setContext(null);
            }
        }
    }

    public static void overrideDevMode(boolean devMode) {
        devModeOverride.set(devMode);
    }

    public static Boolean getDevModeOverride() {
        return devModeOverride.get();
    }

    protected Dispatcher createDispatcher(FilterConfig filterConfig) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = filterConfig.getInitParameter(name);
            params.put(name, value);
        }
        return this.createDispatcher(filterConfig.getServletContext(), params);
    }

    protected Dispatcher createDispatcher(ServletContext ctx, Map<String, String> params) {
        return new Dispatcher(ctx, params);
    }

    @Inject
    public void setStaticResourceLoader(StaticContentLoader staticResourceLoader) {
        this.staticResourceLoader = staticResourceLoader;
    }

    @Inject
    public void setActionMapper(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    protected ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected HttpServletRequest prepareDispatcherAndWrapRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Dispatcher du = Dispatcher.getInstance();
        if (du == null) {
            Dispatcher.setInstance(this.dispatcher);
            this.dispatcher.prepare(request, response);
        } else {
            this.dispatcher = du;
        }
        try {
            request = this.dispatcher.wrapRequest(request, this.getServletContext());
        }
        catch (IOException e) {
            String message = "Could not wrap servlet request with MultipartRequestWrapper!";
            this.log.error(message, (Throwable)e, new String[0]);
            throw new ServletException(message, (Throwable)e);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.showDeprecatedWarning();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletContext servletContext = this.getServletContext();
        String timerKey = "FilterDispatcher_doFilter: ";
        try {
            ActionMapping mapping;
            ValueStack stack = ((ValueStackFactory)this.dispatcher.getContainer().getInstance(ValueStackFactory.class)).createValueStack();
            ActionContext ctx = new ActionContext(stack.getContext());
            ActionContext.setContext((ActionContext)ctx);
            UtilTimerStack.push((String)timerKey);
            request = this.prepareDispatcherAndWrapRequest(request, response);
            try {
                mapping = this.actionMapper.getMapping(request, this.dispatcher.getConfigurationManager());
            }
            catch (Exception ex) {
                this.log.error("error getting ActionMapping", (Throwable)ex, new String[0]);
                this.dispatcher.sendError(request, response, servletContext, 500, ex);
                this.dispatcher.cleanUpRequest(request);
                try {
                    ActionContextCleanUp.cleanUp(req);
                }
                finally {
                    UtilTimerStack.pop((String)timerKey);
                }
                devModeOverride.remove();
                return;
            }
            if (mapping == null) {
                String resourcePath = RequestUtils.getServletPath(request);
                if ("".equals(resourcePath) && null != request.getPathInfo()) {
                    resourcePath = request.getPathInfo();
                }
                if (this.staticResourceLoader.canHandle(resourcePath)) {
                    this.staticResourceLoader.findStaticResource(resourcePath, request, response);
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                return;
            }
            this.dispatcher.serviceAction(request, response, servletContext, mapping);
        }
        finally {
            this.dispatcher.cleanUpRequest(request);
            try {
                ActionContextCleanUp.cleanUp(req);
            }
            finally {
                UtilTimerStack.pop((String)timerKey);
            }
            devModeOverride.remove();
        }
    }

    private void showDeprecatedWarning() {
        String msg = "\n\n***********************************************************************\n*                               WARNING!!!                            *\n*                                                                     *\n* >>> FilterDispatcher <<< is deprecated! Please use the new filters! *\n*                                                                     *\n*           This can be a source of unpredictable problems!           *\n*                                                                     *\n*              Please refer to the docs for more details!             *\n*            http://struts.apache.org/2.x/docs/webxml.html            *\n*                                                                     *\n***********************************************************************\n\n";
        System.out.println(msg);
    }
}

