/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CaseInsensitiveHashMap {
    private final Map<String, String> lowerCaseMap = new ConcurrentHashMap<String, String>();
    private final ConcurrentHashMap<String, Object> map = new ConcurrentHashMap();

    public boolean containsKey(Object key) {
        String realKey = this.lowerCaseMap.get(key.toString().toLowerCase());
        if (realKey == null) {
            return false;
        }
        return this.map.containsKey(realKey);
    }

    public Object get(String key) {
        String realKey = this.lowerCaseMap.get(key.toString().toLowerCase());
        if (realKey == null) {
            return null;
        }
        return this.map.get(realKey);
    }

    public Object put(String key, Object value) {
        String oldKey = this.lowerCaseMap.put(key.toLowerCase(), key);
        Object oldValue = null;
        if (oldKey != null) {
            oldValue = this.map.remove(oldKey);
        }
        this.map.put(key, value);
        return oldValue;
    }

    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.put(key, value);
        }
    }

    public Object remove(String key) {
        String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase());
        if (realKey == null) {
            return null;
        }
        return this.map.remove(realKey);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.lowerCaseMap != null) {
            Iterator<Map.Entry<String, Object>> iterator = this.map.entrySet().iterator();
            Map.Entry<String, Object> current = null;
            while (iterator.hasNext()) {
                current = iterator.next();
                sb.append(current.getKey()).append("=").append(current.getValue());
                sb.append("|");
            }
        }
        return sb.toString();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }
}

