/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.coreframework.db.Exp;
import com.coreframework.db.Order;
import com.coreframework.db.Sql;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpGroup
implements Map<String, Exp> {
    private Map<String, Exp> map = new HashMap<String, Exp>();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(((String)key).toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Exp>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Exp get(Object key) {
        return this.map.get(((String)key).toLowerCase());
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    public void add(String name, Object value) {
        this.put(new Exp(name, value));
    }

    public Exp put(Exp exp) {
        return this.map.put(exp.getName().toLowerCase(), exp);
    }

    @Override
    public Exp put(String key, Exp exp) {
        return this.put(exp);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Exp> m) {
        this.map.putAll(m);
    }

    @Override
    public Exp remove(Object key) {
        return this.map.remove(((String)key).toLowerCase());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Exp> values() {
        return this.map.values();
    }

    public String make(Sign sign) {
        StringBuffer sb = new StringBuffer();
        if (this.map.size() == 0) {
            return sb.toString();
        }
        String splitStr = null;
        switch (sign) {
            case And: {
                splitStr = " and ";
                break;
            }
            case Comma: {
                splitStr = " , ";
                break;
            }
        }
        for (Map.Entry<String, Exp> entry : this.map.entrySet()) {
            if (sb.length() > 0) {
                sb.append(splitStr);
            }
            if (sign.equals((Object)Sign.And)) {
                sb.append("(");
            }
            sb.append(entry.getKey()).append(" ").append(entry.getValue().getOp().toString()).append(" ? ");
            if (!sign.equals((Object)Sign.And)) continue;
            sb.append(")");
        }
        return sb.toString();
    }

    public List<Object> getExpressionValues() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.map.size() == 0) {
            return list;
        }
        for (Map.Entry<String, Exp> entry : this.map.entrySet()) {
            list.add(entry.getValue().getExpressionValue());
        }
        return list;
    }

    public Sql applyToSelect(String table) {
        return this.applyToSelect(table, null, null);
    }

    public Sql applyToSelect(String table, String columns) {
        return this.applyToSelect(table, columns, null);
    }

    public Sql applyToSelect(String table, String columns, Order order) {
        StringBuffer sqlString = new StringBuffer();
        sqlString.append("select ");
        if (columns != null) {
            sqlString.append(columns);
        } else {
            sqlString.append(" * ");
        }
        sqlString.append(" from ").append(table.toString()).append(" where ( 1=1 ) ");
        if (this.map.size() > 0) {
            sqlString.append(" and ").append(this.make(Sign.And));
        }
        if (order != null) {
            sqlString.append(" Order by ").append(order.toString());
        }
        Sql sql = new Sql(sqlString.toString());
        sql.setParamValueList(this.getExpressionValues());
        return sql;
    }

    public Sql applyToSets(String table, String whereString) {
        StringBuffer sqlString = new StringBuffer();
        sqlString.append("update ").append(table.toString()).append(" set  ");
        if (this.map.size() > 0) {
            sqlString.append(this.make(Sign.Comma));
        }
        if (whereString == null) {
            sqlString.append(" where 1=2");
        } else {
            sqlString.append(" where ").append(whereString);
        }
        Sql sql = new Sql(sqlString.toString());
        sql.setParamValueList(this.getExpressionValues());
        return sql;
    }

    public Sql applyToInsert(String table) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(table);
        sb.append(" ( ");
        ArrayList<Object> values = new ArrayList<Object>();
        StringBuffer sign = new StringBuffer();
        int loop = 0;
        for (Map.Entry<String, Exp> entry : this.map.entrySet()) {
            if (loop > 0) {
                sb.append(",");
                sign.append(",");
            }
            sign.append("?");
            sb.append(entry.getKey());
            values.add(entry.getValue().getExpressionValue());
            ++loop;
        }
        if (loop == 0) {
            throw new Exception("\u672a\u5b9a\u4e49\u9700\u8981insert\u7684\u5b57\u6bb5");
        }
        sb.append(" ) ");
        sb.append("values (").append(sign.toString()).append(")");
        Sql sql = new Sql(sb.toString());
        sql.setParamValueList(values);
        return sql;
    }

    public static enum Sign {
        And,
        Comma;

    }
}

