/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.coreframework.db.DB;
import com.coreframework.db.NamedParameterUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class Sql
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sqlString;
    private String originalSql;
    private boolean useLimitSql;
    private boolean hasNamed;
    private List<Object> paramValueList;
    private ConcurrentHashMap<String, Object> valMap;
    private ConcurrentHashMap<String, String> varMap;

    public static void main(String[] args) {
    }

    public boolean isUseLimitSql() {
        return this.useLimitSql;
    }

    public void setUseLimitSql() {
        this.useLimitSql = true;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public Sql(String originalSql) {
        this.sqlString = originalSql;
        this.originalSql = originalSql;
        this.hasNamed = false;
        this.useLimitSql = DB.isUseLimitSql() ? DB.isUseLimitSql() : false;
    }

    public String getSqlString() {
        if (this.hasNamed) {
            this.sqlString = NamedParameterUtils.parseSqlStatementIntoString(this.originalSql);
        }
        if (this.varMap != null) {
            Iterator<Map.Entry<String, String>> iterator = this.varMap.entrySet().iterator();
            Map.Entry<String, String> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                this.sqlString = this.sqlString.replace(entry.getKey(), entry.getValue());
            }
        }
        return this.sqlString;
    }

    public Sql setSqlString(String sqlString) {
        this.sqlString = sqlString;
        return this;
    }

    public Sql addParamValue(Object paramValue) {
        if (this.paramValueList == null) {
            this.paramValueList = new Vector<Object>();
        }
        this.paramValueList.add(paramValue);
        return this;
    }

    public void setNamedParamValue(Object bean) {
        Object[] vals;
        this.hasNamed = true;
        this.paramValueList = new Vector<Object>();
        Object[] objectArray = vals = NamedParameterUtils.buildValueArray(this.originalSql, bean);
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.paramValueList.add(object);
            ++n2;
        }
    }

    public Sql addNameValuePair(String name, Object value) {
        this.hasNamed = true;
        if (this.valMap == null) {
            this.valMap = new ConcurrentHashMap();
        }
        this.valMap.put(name, value);
        return this;
    }

    public Sql addVar(String name, String value) {
        if (this.varMap == null) {
            this.varMap = new ConcurrentHashMap();
        }
        this.varMap.put(name, value);
        return this;
    }

    public Object[] getParamValueList() {
        if (this.valMap != null && this.valMap.size() > 0) {
            return NamedParameterUtils.buildValueArray(this.originalSql, this.valMap);
        }
        if (this.paramValueList == null) {
            return new Object[0];
        }
        return this.paramValueList.toArray();
    }

    public void setParamValueList(List<Object> paramValueList) {
        this.paramValueList = paramValueList;
    }

    public void setParamValueList(Object[] paramValueList) {
        if (paramValueList == null) {
            return;
        }
        this.paramValueList = new Vector<Object>();
        Object[] objectArray = paramValueList;
        int n = paramValueList.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.paramValueList.add(object);
            ++n2;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSqlString());
        sb.append("[");
        Object[] vals = this.getParamValueList();
        if (vals != null) {
            int i = 0;
            Object[] objectArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                sb.append(object);
                if (++i < vals.length) {
                    sb.append(",");
                }
                ++n2;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    String getValues() {
        Object[] vals = this.getParamValueList();
        StringBuffer sb = new StringBuffer();
        if (vals != null) {
            int i = 0;
            Object[] objectArray = vals;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                sb.append(object);
                if (++i < vals.length) {
                    sb.append("%?&|");
                }
                ++n2;
            }
        }
        return sb.toString();
    }
}

