/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils.handlers;

import com.coreframework.db.QueryResult;
import com.yihu.das.dbutils.RowProcessor;
import com.yihu.das.dbutils.handlers.AbstractListHandler;
import com.yihu.das.dbutils.handlers.ArrayHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class BeanListHandler<T>
extends AbstractListHandler<T> {
    private final Class<T> type;
    private final RowProcessor convert;

    public BeanListHandler(Class<T> type) {
        this(type, ArrayHandler.ROW_PROCESSOR);
    }

    public BeanListHandler(Class<T> type, RowProcessor convert) {
        this.type = type;
        this.convert = convert;
    }

    @Override
    protected T handleRow(ResultSet rs) throws SQLException {
        return this.convert.toBean(rs, this.type);
    }

    @Override
    public QueryResult<List<T>> handle(ResultSet rs, int start, int pageSize, int rowCount) throws SQLException {
        QueryResult<List<List<T>>> qs = new QueryResult<List<List<T>>>();
        List<T> ls = this.convert.toBeanList(rs, this.type);
        qs.setRowCount(rowCount);
        qs.setResult(ls);
        try {
            int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)pageSize);
            qs.setPageCount(pageCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        qs.setPageSize(pageSize);
        return qs;
    }
}

