/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jocl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ConstructorUtil {
    public static Constructor getConstructor(Class type, Class[] argTypes) {
        if (type == null || argTypes == null) {
            throw new NullPointerException();
        }
        Constructor<Object> ctor = null;
        try {
            ctor = type.getConstructor(argTypes);
        }
        catch (Exception e) {
            ctor = null;
        }
        if (ctor == null) {
            Constructor<?>[] ctors = type.getConstructors();
            int i = 0;
            while (i < ctors.length) {
                Class<?>[] paramtypes = ctors[i].getParameterTypes();
                if (paramtypes.length == argTypes.length) {
                    boolean canuse = true;
                    int j = 0;
                    while (j < paramtypes.length) {
                        if (!paramtypes[j].isAssignableFrom(argTypes[j])) {
                            canuse = false;
                            break;
                        }
                        ++j;
                    }
                    if (canuse) {
                        ctor = ctors[i];
                        break;
                    }
                }
                ++i;
            }
        }
        return ctor;
    }

    public static Object invokeConstructor(Class type, Class[] argTypes, Object[] argValues) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return ConstructorUtil.getConstructor(type, argTypes).newInstance(argValues);
    }
}

