/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import java.util.ArrayList;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;

public class NameRecord
extends RecordData {
    private String name;
    public static Biff7 biff7 = new Biff7();
    private static final int cellReference = 58;
    private static final int areaReference = 59;
    private static final int subExpression = 41;
    private static final int union = 16;
    private ArrayList ranges;

    NameRecord(Record t) {
        block11: {
            super(t);
            try {
                this.ranges = new ArrayList();
                byte[] data = this.getRecord().getData();
                byte length = data[3];
                this.name = StringHelper.getString(data, length, 15);
                int pos = length + 15;
                if (data[pos] == 58) {
                    int sheet = IntegerHelper.getInt(data[pos + 1], data[pos + 2]);
                    int row = IntegerHelper.getInt(data[pos + 3], data[pos + 4]);
                    int columnMask = IntegerHelper.getInt(data[pos + 5], data[pos + 6]);
                    int column = columnMask & 0xFF;
                    Assert.verify((columnMask & 0xC0000) == 0);
                    NameRange r = new NameRange(sheet, column, row, sheet, column, row);
                    this.ranges.add(r);
                    break block11;
                }
                if (data[pos] == 59) {
                    int sheet1 = 0;
                    boolean sheet2 = false;
                    int r1 = 0;
                    int columnMask = 0;
                    int c1 = 0;
                    int r2 = 0;
                    int c2 = 0;
                    NameRange range = null;
                    while (pos < data.length) {
                        sheet1 = IntegerHelper.getInt(data[pos + 1], data[pos + 2]);
                        r1 = IntegerHelper.getInt(data[pos + 3], data[pos + 4]);
                        r2 = IntegerHelper.getInt(data[pos + 5], data[pos + 6]);
                        columnMask = IntegerHelper.getInt(data[pos + 7], data[pos + 8]);
                        c1 = columnMask & 0xFF;
                        Assert.verify((columnMask & 0xC0000) == 0);
                        columnMask = IntegerHelper.getInt(data[pos + 9], data[pos + 10]);
                        c2 = columnMask & 0xFF;
                        Assert.verify((columnMask & 0xC0000) == 0);
                        range = new NameRange(sheet1, c1, r1, sheet1, c2, r2);
                        this.ranges.add(range);
                        pos += 11;
                    }
                    break block11;
                }
                if (data[pos] != 41) break block11;
                int sheet1 = 0;
                boolean sheet2 = false;
                int r1 = 0;
                int columnMask = 0;
                int c1 = 0;
                int r2 = 0;
                int c2 = 0;
                NameRange range = null;
                if (pos < data.length && data[pos] != 58 && data[pos] != 59) {
                    if (data[pos] == 41) {
                        pos += 3;
                    } else if (data[pos] == 16) {
                        ++pos;
                    }
                }
                while (pos < data.length) {
                    sheet1 = IntegerHelper.getInt(data[pos + 1], data[pos + 2]);
                    r1 = IntegerHelper.getInt(data[pos + 3], data[pos + 4]);
                    r2 = IntegerHelper.getInt(data[pos + 5], data[pos + 6]);
                    columnMask = IntegerHelper.getInt(data[pos + 7], data[pos + 8]);
                    c1 = columnMask & 0xFF;
                    Assert.verify((columnMask & 0xC0000) == 0);
                    columnMask = IntegerHelper.getInt(data[pos + 9], data[pos + 10]);
                    c2 = columnMask & 0xFF;
                    Assert.verify((columnMask & 0xC0000) == 0);
                    range = new NameRange(sheet1, c1, r1, sheet1, c2, r2);
                    this.ranges.add(range);
                    if ((pos += 11) >= data.length || data[pos] == 58 || data[pos] == 59) continue;
                    if (data[pos] == 41) {
                        pos += 3;
                        continue;
                    }
                    if (data[pos] != 16) continue;
                    ++pos;
                }
            }
            catch (Throwable t1) {
                System.err.println("Warning:  cannot read name");
                this.name = "ERROR";
            }
        }
    }

    NameRecord(Record t, Biff7 dummy) {
        block11: {
            super(t);
            try {
                this.ranges = new ArrayList();
                byte[] data = this.getRecord().getData();
                byte length = data[3];
                this.name = StringHelper.getString(data, length, 14);
                int pos = length + 14;
                if (data[pos] == 58) {
                    int sheet = IntegerHelper.getInt(data[pos + 11], data[pos + 12]);
                    int row = IntegerHelper.getInt(data[pos + 15], data[pos + 16]);
                    byte column = data[pos + 17];
                    NameRange r = new NameRange(sheet, column, row, sheet, column, row);
                    this.ranges.add(r);
                    break block11;
                }
                if (data[pos] == 59) {
                    int sheet1 = 0;
                    int sheet2 = 0;
                    int r1 = 0;
                    boolean columnMask = false;
                    byte c1 = 0;
                    int r2 = 0;
                    byte c2 = 0;
                    NameRange range = null;
                    while (pos < data.length) {
                        sheet1 = IntegerHelper.getInt(data[pos + 11], data[pos + 12]);
                        sheet2 = IntegerHelper.getInt(data[pos + 13], data[pos + 14]);
                        r1 = IntegerHelper.getInt(data[pos + 15], data[pos + 16]);
                        r2 = IntegerHelper.getInt(data[pos + 17], data[pos + 18]);
                        c1 = data[pos + 19];
                        c2 = data[pos + 20];
                        range = new NameRange(sheet1, c1, r1, sheet1, c2, r2);
                        this.ranges.add(range);
                        pos += 21;
                    }
                    break block11;
                }
                if (data[pos] != 41) break block11;
                int sheet1 = 0;
                int sheet2 = 0;
                int r1 = 0;
                boolean columnMask = false;
                byte c1 = 0;
                int r2 = 0;
                byte c2 = 0;
                NameRange range = null;
                if (pos < data.length && data[pos] != 58 && data[pos] != 59) {
                    if (data[pos] == 41) {
                        pos += 3;
                    } else if (data[pos] == 16) {
                        ++pos;
                    }
                }
                while (pos < data.length) {
                    sheet1 = IntegerHelper.getInt(data[pos + 11], data[pos + 12]);
                    sheet2 = IntegerHelper.getInt(data[pos + 13], data[pos + 14]);
                    r1 = IntegerHelper.getInt(data[pos + 15], data[pos + 16]);
                    r2 = IntegerHelper.getInt(data[pos + 17], data[pos + 18]);
                    c1 = data[pos + 19];
                    c2 = data[pos + 20];
                    range = new NameRange(sheet1, c1, r1, sheet1, c2, r2);
                    this.ranges.add(range);
                    if ((pos += 21) >= data.length || data[pos] == 58 || data[pos] == 59) continue;
                    if (data[pos] == 41) {
                        pos += 3;
                        continue;
                    }
                    if (data[pos] != 16) continue;
                    ++pos;
                }
            }
            catch (Throwable t1) {
                System.err.println("Warning:  cannot read name");
                this.name = "ERROR";
            }
        }
    }

    String getName() {
        return this.name;
    }

    NameRange[] getRanges() {
        Object[] o = this.ranges.toArray();
        NameRange[] nr = new NameRange[o.length];
        int i = 0;
        while (i < o.length) {
            nr[i] = (NameRange)o[i];
            ++i;
        }
        return nr;
    }

    public byte[] getData() {
        return this.getRecord().getData();
    }

    class NameRange {
        private int columnFirst;
        private int rowFirst;
        private int columnLast;
        private int rowLast;
        private int sheetFirst;
        private int sheetLast;

        NameRange(int s1, int c1, int r1, int s2, int c2, int r2) {
            this.columnFirst = c1;
            this.rowFirst = r1;
            this.columnLast = c2;
            this.rowLast = r2;
            this.sheetFirst = s1;
            this.sheetLast = s2;
        }

        int getFirstColumn() {
            return this.columnFirst;
        }

        int getFirstRow() {
            return this.rowFirst;
        }

        int getLastColumn() {
            return this.columnLast;
        }

        int getLastRow() {
            return this.rowLast;
        }

        int getFirstSheet() {
            return this.sheetFirst;
        }

        int getLastSheet() {
            return this.sheetLast;
        }
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

