/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class RefTypeAccessor
extends TypeAccessor {
    RefTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean forBind) throws SQLException {
        this.init(stmt, 111, 111, form, forBind);
        this.initForDataAccess(external_type, 0, typeName);
    }

    RefTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName) throws SQLException {
        this.init(stmt, 111, 111, form, false);
        this.initForDescribe(111, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
        this.initForDataAccess(0, max_len, typeName);
    }

    RefTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, String typeName, OracleType otype) throws SQLException {
        this.init(stmt, 111, 111, form, false);
        this.describeOtype = otype;
        this.initForDescribe(111, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
        this.internalOtype = otype;
        this.initForDataAccess(0, max_len, typeName);
    }

    OracleType otypeFromName(String typeName) throws SQLException {
        if (!this.outBind) {
            return TypeDescriptor.getTypeDescriptor(typeName, this.statement.connection).getPickler();
        }
        return StructDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeADT();
    }

    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        super.initForDataAccess(external_type, max_len, typeName);
        this.byteLength = this.statement.connection.refTypeAccessorByteLen;
    }

    REF getREF(int currentRow) throws SQLException {
        REF result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            byte[] data = this.pickledBytes(currentRow);
            OracleTypeADT otype = (OracleTypeADT)this.internalOtype;
            result = new REF(otype.getFullName(), (Connection)this.statement.connection, data);
        }
        return result;
    }

    Object getObject(int currentRow) throws SQLException {
        return this.getREF(currentRow);
    }

    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getREF(currentRow);
    }

    Object getObject(int currentRow, Map map) throws SQLException {
        return this.getREF(currentRow);
    }
}

