/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationContext;
import org.springframework.http.converter.json.SpringHandlerInstantiator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class Jackson2ObjectMapperBuilder {
    private boolean createXmlMapper = false;
    private DateFormat dateFormat;
    private Locale locale;
    private TimeZone timeZone;
    private AnnotationIntrospector annotationIntrospector;
    private PropertyNamingStrategy propertyNamingStrategy;
    private TypeResolverBuilder<?> defaultTyping;
    private JsonInclude.Include serializationInclusion;
    private FilterProvider filters;
    private final Map<Class<?>, Class<?>> mixIns = new HashMap();
    private final Map<Class<?>, JsonSerializer<?>> serializers = new LinkedHashMap();
    private final Map<Class<?>, JsonDeserializer<?>> deserializers = new LinkedHashMap();
    private final Map<Object, Boolean> features = new HashMap<Object, Boolean>();
    private List<Module> modules;
    private Class<? extends Module>[] moduleClasses;
    private boolean findModulesViaServiceLoader = false;
    private boolean findWellKnownModules = true;
    private ClassLoader moduleClassLoader = this.getClass().getClassLoader();
    private HandlerInstantiator handlerInstantiator;
    private ApplicationContext applicationContext;
    private Boolean defaultUseWrapper;

    public Jackson2ObjectMapperBuilder createXmlMapper(boolean createXmlMapper) {
        this.createXmlMapper = createXmlMapper;
        return this;
    }

    public Jackson2ObjectMapperBuilder dateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public Jackson2ObjectMapperBuilder simpleDateFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
        return this;
    }

    public Jackson2ObjectMapperBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public Jackson2ObjectMapperBuilder locale(String localeString) {
        this.locale = StringUtils.parseLocaleString((String)localeString);
        return this;
    }

    public Jackson2ObjectMapperBuilder timeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Jackson2ObjectMapperBuilder timeZone(String timeZoneString) {
        this.timeZone = StringUtils.parseTimeZoneString((String)timeZoneString);
        return this;
    }

    public Jackson2ObjectMapperBuilder annotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this.annotationIntrospector = annotationIntrospector;
        return this;
    }

    public Jackson2ObjectMapperBuilder propertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.propertyNamingStrategy = propertyNamingStrategy;
        return this;
    }

    public Jackson2ObjectMapperBuilder defaultTyping(TypeResolverBuilder<?> typeResolverBuilder) {
        this.defaultTyping = typeResolverBuilder;
        return this;
    }

    public Jackson2ObjectMapperBuilder serializationInclusion(JsonInclude.Include serializationInclusion) {
        this.serializationInclusion = serializationInclusion;
        return this;
    }

    public Jackson2ObjectMapperBuilder filters(FilterProvider filters) {
        this.filters = filters;
        return this;
    }

    public Jackson2ObjectMapperBuilder mixIn(Class<?> target, Class<?> mixinSource) {
        if (mixinSource != null) {
            this.mixIns.put(target, mixinSource);
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder mixIns(Map<Class<?>, Class<?>> mixIns) {
        if (mixIns != null) {
            this.mixIns.putAll(mixIns);
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder serializers(JsonSerializer<?> ... serializers) {
        if (serializers != null) {
            for (JsonSerializer<?> serializer : serializers) {
                Class handledType = serializer.handledType();
                if (handledType == null || handledType == Object.class) {
                    throw new IllegalArgumentException("Unknown handled type in " + serializer.getClass().getName());
                }
                this.serializers.put(serializer.handledType(), serializer);
            }
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder serializerByType(Class<?> type, JsonSerializer<?> serializer) {
        if (serializer != null) {
            this.serializers.put(type, serializer);
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder serializersByType(Map<Class<?>, JsonSerializer<?>> serializers) {
        if (serializers != null) {
            this.serializers.putAll(serializers);
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder deserializers(JsonDeserializer<?> ... deserializers) {
        if (deserializers != null) {
            for (JsonDeserializer<?> deserializer : deserializers) {
                Class handledType = deserializer.handledType();
                if (handledType == null || handledType == Object.class) {
                    throw new IllegalArgumentException("Unknown handled type in " + deserializer.getClass().getName());
                }
                this.deserializers.put(deserializer.handledType(), deserializer);
            }
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder deserializerByType(Class<?> type, JsonDeserializer<?> deserializer) {
        if (deserializer != null) {
            this.deserializers.put(type, deserializer);
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder deserializersByType(Map<Class<?>, JsonDeserializer<?>> deserializers) {
        if (deserializers != null) {
            this.deserializers.putAll(deserializers);
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder autoDetectFields(boolean autoDetectFields) {
        this.features.put(MapperFeature.AUTO_DETECT_FIELDS, autoDetectFields);
        return this;
    }

    public Jackson2ObjectMapperBuilder autoDetectGettersSetters(boolean autoDetectGettersSetters) {
        this.features.put(MapperFeature.AUTO_DETECT_GETTERS, autoDetectGettersSetters);
        this.features.put(MapperFeature.AUTO_DETECT_SETTERS, autoDetectGettersSetters);
        this.features.put(MapperFeature.AUTO_DETECT_IS_GETTERS, autoDetectGettersSetters);
        return this;
    }

    public Jackson2ObjectMapperBuilder defaultViewInclusion(boolean defaultViewInclusion) {
        this.features.put(MapperFeature.DEFAULT_VIEW_INCLUSION, defaultViewInclusion);
        return this;
    }

    public Jackson2ObjectMapperBuilder failOnUnknownProperties(boolean failOnUnknownProperties) {
        this.features.put(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        return this;
    }

    public Jackson2ObjectMapperBuilder failOnEmptyBeans(boolean failOnEmptyBeans) {
        this.features.put(SerializationFeature.FAIL_ON_EMPTY_BEANS, failOnEmptyBeans);
        return this;
    }

    public Jackson2ObjectMapperBuilder indentOutput(boolean indentOutput) {
        this.features.put(SerializationFeature.INDENT_OUTPUT, indentOutput);
        return this;
    }

    public Jackson2ObjectMapperBuilder defaultUseWrapper(boolean defaultUseWrapper) {
        this.defaultUseWrapper = defaultUseWrapper;
        return this;
    }

    public Jackson2ObjectMapperBuilder featuresToEnable(Object ... featuresToEnable) {
        if (featuresToEnable != null) {
            for (Object feature : featuresToEnable) {
                this.features.put(feature, Boolean.TRUE);
            }
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder featuresToDisable(Object ... featuresToDisable) {
        if (featuresToDisable != null) {
            for (Object feature : featuresToDisable) {
                this.features.put(feature, Boolean.FALSE);
            }
        }
        return this;
    }

    public Jackson2ObjectMapperBuilder modules(Module ... modules) {
        return this.modules(Arrays.asList(modules));
    }

    public Jackson2ObjectMapperBuilder modules(List<Module> modules) {
        this.modules = new LinkedList<Module>(modules);
        this.findModulesViaServiceLoader = false;
        this.findWellKnownModules = false;
        return this;
    }

    public Jackson2ObjectMapperBuilder modulesToInstall(Module ... modules) {
        this.modules = Arrays.asList(modules);
        this.findWellKnownModules = true;
        return this;
    }

    public Jackson2ObjectMapperBuilder modulesToInstall(Class<? extends Module> ... modules) {
        this.moduleClasses = modules;
        this.findWellKnownModules = true;
        return this;
    }

    public Jackson2ObjectMapperBuilder findModulesViaServiceLoader(boolean findModules) {
        this.findModulesViaServiceLoader = findModules;
        return this;
    }

    public Jackson2ObjectMapperBuilder moduleClassLoader(ClassLoader moduleClassLoader) {
        this.moduleClassLoader = moduleClassLoader;
        return this;
    }

    public Jackson2ObjectMapperBuilder handlerInstantiator(HandlerInstantiator handlerInstantiator) {
        this.handlerInstantiator = handlerInstantiator;
        return this;
    }

    public Jackson2ObjectMapperBuilder applicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public <T extends ObjectMapper> T build() {
        ObjectMapper mapper = this.createXmlMapper ? (this.defaultUseWrapper != null ? new XmlObjectMapperInitializer().create(this.defaultUseWrapper) : new XmlObjectMapperInitializer().create()) : new ObjectMapper();
        this.configure(mapper);
        return (T)mapper;
    }

    public void configure(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        if (this.findModulesViaServiceLoader) {
            objectMapper.registerModules((Iterable)ObjectMapper.findModules((ClassLoader)this.moduleClassLoader));
        } else if (this.findWellKnownModules) {
            this.registerWellKnownModulesIfAvailable(objectMapper);
        }
        if (this.modules != null) {
            for (Module module : this.modules) {
                objectMapper.registerModule(module);
            }
        }
        if (this.moduleClasses != null) {
            for (Class<? extends Module> module : this.moduleClasses) {
                objectMapper.registerModule((Module)BeanUtils.instantiate(module));
            }
        }
        if (this.dateFormat != null) {
            objectMapper.setDateFormat(this.dateFormat);
        }
        if (this.locale != null) {
            objectMapper.setLocale(this.locale);
        }
        if (this.timeZone != null) {
            objectMapper.setTimeZone(this.timeZone);
        }
        if (this.annotationIntrospector != null) {
            objectMapper.setAnnotationIntrospector(this.annotationIntrospector);
        }
        if (this.propertyNamingStrategy != null) {
            objectMapper.setPropertyNamingStrategy(this.propertyNamingStrategy);
        }
        if (this.defaultTyping != null) {
            objectMapper.setDefaultTyping(this.defaultTyping);
        }
        if (this.serializationInclusion != null) {
            objectMapper.setSerializationInclusion(this.serializationInclusion);
        }
        if (this.filters != null) {
            objectMapper.setFilterProvider(this.filters);
        }
        for (Class clazz : this.mixIns.keySet()) {
            objectMapper.addMixIn(clazz, this.mixIns.get(clazz));
        }
        if (!this.serializers.isEmpty() || !this.deserializers.isEmpty()) {
            SimpleModule module = new SimpleModule();
            this.addSerializers(module);
            this.addDeserializers(module);
            objectMapper.registerModule((Module)module);
        }
        this.customizeDefaultFeatures(objectMapper);
        for (Object e : this.features.keySet()) {
            this.configureFeature(objectMapper, e, this.features.get(e));
        }
        if (this.handlerInstantiator != null) {
            objectMapper.setHandlerInstantiator(this.handlerInstantiator);
        } else if (this.applicationContext != null) {
            objectMapper.setHandlerInstantiator((HandlerInstantiator)new SpringHandlerInstantiator(this.applicationContext.getAutowireCapableBeanFactory()));
        }
    }

    private void customizeDefaultFeatures(ObjectMapper objectMapper) {
        if (!this.features.containsKey(MapperFeature.DEFAULT_VIEW_INCLUSION)) {
            this.configureFeature(objectMapper, MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        }
        if (!this.features.containsKey(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            this.configureFeature(objectMapper, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    }

    private <T> void addSerializers(SimpleModule module) {
        for (Class<?> type : this.serializers.keySet()) {
            module.addSerializer(type, this.serializers.get(type));
        }
    }

    private <T> void addDeserializers(SimpleModule module) {
        for (Class<?> type : this.deserializers.keySet()) {
            module.addDeserializer(type, this.deserializers.get(type));
        }
    }

    private void configureFeature(ObjectMapper objectMapper, Object feature, boolean enabled) {
        if (feature instanceof JsonParser.Feature) {
            objectMapper.configure((JsonParser.Feature)feature, enabled);
        } else if (feature instanceof JsonGenerator.Feature) {
            objectMapper.configure((JsonGenerator.Feature)feature, enabled);
        } else if (feature instanceof SerializationFeature) {
            objectMapper.configure((SerializationFeature)feature, enabled);
        } else if (feature instanceof DeserializationFeature) {
            objectMapper.configure((DeserializationFeature)feature, enabled);
        } else if (feature instanceof MapperFeature) {
            objectMapper.configure((MapperFeature)feature, enabled);
        } else {
            throw new FatalBeanException("Unknown feature class: " + feature.getClass().getName());
        }
    }

    private void registerWellKnownModulesIfAvailable(ObjectMapper objectMapper) {
        if (ClassUtils.isPresent((String)"java.nio.file.Path", (ClassLoader)this.moduleClassLoader)) {
            try {
                Class jdk7Module = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jdk7.Jdk7Module", (ClassLoader)this.moduleClassLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)jdk7Module));
            }
            catch (ClassNotFoundException jdk7Module) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"java.util.Optional", (ClassLoader)this.moduleClassLoader)) {
            try {
                Class jdk8Module = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jdk8.Jdk8Module", (ClassLoader)this.moduleClassLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)jdk8Module));
            }
            catch (ClassNotFoundException jdk8Module) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"java.time.LocalDate", (ClassLoader)this.moduleClassLoader)) {
            try {
                Class javaTimeModule = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", (ClassLoader)this.moduleClassLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)javaTimeModule));
            }
            catch (ClassNotFoundException javaTimeModule) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"org.joda.time.LocalDate", (ClassLoader)this.moduleClassLoader)) {
            try {
                Class jodaModule = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.joda.JodaModule", (ClassLoader)this.moduleClassLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)jodaModule));
            }
            catch (ClassNotFoundException jodaModule) {
                // empty catch block
            }
        }
        if (ClassUtils.isPresent((String)"kotlin.Unit", (ClassLoader)this.moduleClassLoader)) {
            try {
                Class kotlinModule = ClassUtils.forName((String)"com.fasterxml.jackson.module.kotlin.KotlinModule", (ClassLoader)this.moduleClassLoader);
                objectMapper.registerModule((Module)BeanUtils.instantiateClass((Class)kotlinModule));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static Jackson2ObjectMapperBuilder json() {
        return new Jackson2ObjectMapperBuilder();
    }

    public static Jackson2ObjectMapperBuilder xml() {
        return new Jackson2ObjectMapperBuilder().createXmlMapper(true);
    }

    private static class XmlObjectMapperInitializer {
        private static final XMLResolver NO_OP_XML_RESOLVER = new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String base, String ns) {
                return StreamUtils.emptyInput();
            }
        };

        private XmlObjectMapperInitializer() {
        }

        public ObjectMapper create() {
            return new XmlMapper(XmlObjectMapperInitializer.xmlInputFactory());
        }

        public ObjectMapper create(boolean defaultUseWrapper) {
            JacksonXmlModule module = new JacksonXmlModule();
            module.setDefaultUseWrapper(defaultUseWrapper);
            return new XmlMapper(new XmlFactory(XmlObjectMapperInitializer.xmlInputFactory()), module);
        }

        private static XMLInputFactory xmlInputFactory() {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            inputFactory.setXMLResolver(NO_OP_XML_RESOLVER);
            return inputFactory;
        }
    }
}

