/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo
implements Comparable<FieldInfo> {
    private final String name;
    private final Method method;
    private final Field field;
    private final Class<?> fieldClass;
    private final Type fieldType;
    private final Class<?> declaringClass;

    public FieldInfo(String name, Class<?> declaringClass, Class<?> fieldClass, Type fieldType, Method method, Field field) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.fieldClass = fieldClass;
        this.fieldType = fieldType;
        this.method = method;
        this.field = field;
        if (method != null) {
            method.setAccessible(true);
        }
        if (field != null) {
            field.setAccessible(true);
        }
    }

    public FieldInfo(String name, Method method, Field field) {
        this.name = name;
        this.method = method;
        this.field = field;
        if (method != null) {
            method.setAccessible(true);
        }
        if (field != null) {
            field.setAccessible(true);
        }
        if (method != null) {
            if (method.getParameterTypes().length == 1) {
                this.fieldClass = method.getParameterTypes()[0];
                this.fieldType = method.getGenericParameterTypes()[0];
            } else {
                this.fieldClass = method.getReturnType();
                this.fieldType = method.getGenericReturnType();
            }
            this.declaringClass = method.getDeclaringClass();
        } else {
            this.fieldClass = field.getType();
            this.fieldType = field.getGenericType();
            this.declaringClass = field.getDeclaringClass();
        }
    }

    public String toString() {
        return this.name;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public int compareTo(FieldInfo o) {
        return this.name.compareTo(o.name);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = null;
        if (this.method != null) {
            annotation = this.method.getAnnotation(annotationClass);
        }
        if (annotation == null && this.field != null) {
            annotation = this.field.getAnnotation(annotationClass);
        }
        return annotation;
    }

    public Object get(Object javaObject) throws IllegalAccessException, InvocationTargetException {
        if (this.method != null) {
            Object value = this.method.invoke(javaObject, new Object[0]);
            return value;
        }
        return this.field.get(javaObject);
    }

    public void set(Object javaObject, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.method != null) {
            this.method.invoke(javaObject, value);
            return;
        }
        this.field.set(javaObject, value);
    }

    public void setAccessible(boolean flag) throws SecurityException {
        if (this.method != null) {
            this.method.setAccessible(flag);
            return;
        }
        this.field.setAccessible(flag);
    }
}

