/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.coreframework.db.BeanPropertySqlParameterSource;
import com.coreframework.db.MapSqlParameterSource;
import com.coreframework.db.ParsedSql;
import com.coreframework.db.SqlParameter;
import com.coreframework.db.SqlParameterSource;
import com.coreframework.db.SqlParameterValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class NamedParameterUtils {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};

    public static void main(String[] args) {
    }

    /*
     * Unable to fully structure code
     */
    public static ParsedSql parseSqlStatement(String sql) {
        namedParameters = new HashSet<String>();
        parsedSql = new ParsedSql(sql);
        statement = sql.toCharArray();
        namedParameterCount = 0;
        unnamedParameterCount = 0;
        totalParameterCount = 0;
        i = 0;
        while (i < statement.length) {
            block7: {
                block6: {
                    skipToPosition = NamedParameterUtils.skipCommentsAndQuotes(statement, i);
                    if (i != skipToPosition) {
                        if (skipToPosition >= statement.length) break;
                        i = skipToPosition;
                    }
                    if ((c = statement[i]) != ':' && c != '&') break block6;
                    j = i + 1;
                    if (j >= statement.length || statement[j] != ':' || c != ':') ** GOTO lbl19
                    i += 2;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        ++j;
lbl19:
                        // 2 sources

                        ** while (j < statement.length && !NamedParameterUtils.isParameterSeparator((char)statement[j]))
                    }
lbl20:
                    // 1 sources

                    if (j - i > 1) {
                        parameter = sql.substring(i + 1, j);
                        if (!namedParameters.contains(parameter)) {
                            namedParameters.add(parameter);
                            ++namedParameterCount;
                        }
                        parsedSql.addNamedParameter(parameter, i, j);
                        ++totalParameterCount;
                    }
                    i = j - 1;
                    break block7;
                }
                if (c == '?') {
                    ++unnamedParameterCount;
                    ++totalParameterCount;
                }
            }
            ++i;
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        int i = 0;
        while (i < START_SKIP.length) {
            if (statement[position] == START_SKIP[i].charAt(0)) {
                boolean match = true;
                int j = 1;
                while (j < START_SKIP[i].length()) {
                    if (statement[position + j] != START_SKIP[i].charAt(j)) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    int offset = START_SKIP[i].length();
                    int m = position + offset;
                    while (m < statement.length) {
                        if (statement[m] == STOP_SKIP[i].charAt(0)) {
                            boolean endMatch = true;
                            int endPos = m;
                            int n = 1;
                            while (n < STOP_SKIP[i].length()) {
                                if (m + n >= statement.length) {
                                    return statement.length;
                                }
                                if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                                    endMatch = false;
                                    break;
                                }
                                endPos = m + n;
                                ++n;
                            }
                            if (endMatch) {
                                return endPos + 1;
                            }
                        }
                        ++m;
                    }
                    return statement.length;
                }
            }
            ++i;
        }
        return position;
    }

    public static String substituteNamedParameters(ParsedSql parsedSql, SqlParameterSource paramSource) {
        String originalSql = parsedSql.getOriginalSql();
        StringBuilder actualSql = new StringBuilder();
        List paramNames = parsedSql.getParameterNames();
        int lastIndex = 0;
        int i = 0;
        while (i < paramNames.size()) {
            String paramName = (String)paramNames.get(i);
            int[] indexes = parsedSql.getParameterIndexes(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            actualSql.append(originalSql.substring(lastIndex, startIndex));
            if (paramSource != null && paramSource.hasValue(paramName)) {
                Object value = paramSource.getValue(paramName);
                if (value instanceof Collection) {
                    Iterator entryIter = ((Collection)value).iterator();
                    int k = 0;
                    while (entryIter.hasNext()) {
                        if (k > 0) {
                            actualSql.append(", ");
                        }
                        ++k;
                        Object entryItem = entryIter.next();
                        if (entryItem instanceof Object[]) {
                            Object[] expressionList = (Object[])entryItem;
                            actualSql.append("(");
                            int m = 0;
                            while (m < expressionList.length) {
                                if (m > 0) {
                                    actualSql.append(", ");
                                }
                                actualSql.append("?");
                                ++m;
                            }
                            actualSql.append(")");
                            continue;
                        }
                        actualSql.append("?");
                    }
                } else {
                    actualSql.append("?");
                }
            } else {
                actualSql.append("?");
            }
            lastIndex = endIndex;
            ++i;
        }
        actualSql.append(originalSql.substring(lastIndex, originalSql.length()));
        return actualSql.toString();
    }

    public static Object[] buildValueArray(ParsedSql parsedSql, SqlParameterSource paramSource, List declaredParams) {
        Object[] paramArray = new Object[parsedSql.getTotalParameterCount()];
        if (parsedSql.getNamedParameterCount() > 0 && parsedSql.getUnnamedParameterCount() > 0) {
            return null;
        }
        List paramNames = parsedSql.getParameterNames();
        int i = 0;
        while (i < paramNames.size()) {
            String paramName = (String)paramNames.get(i);
            try {
                Object value = paramSource.getValue(paramName);
                SqlParameter param = NamedParameterUtils.findParameter(declaredParams, paramName, i);
                paramArray[i] = param == null ? value : new SqlParameterValue(param, value);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                return null;
            }
            ++i;
        }
        return paramArray;
    }

    private static SqlParameter findParameter(List declaredParams, String paramName, int paramIndex) {
        if (declaredParams != null) {
            SqlParameter declaredParam;
            for (SqlParameter declaredParam2 : declaredParams) {
                if (!paramName.equals(declaredParam2.getName())) continue;
                return declaredParam2;
            }
            if (paramIndex < declaredParams.size() && (declaredParam = (SqlParameter)declaredParams.get(paramIndex)).getName() == null) {
                return declaredParam;
            }
        }
        return null;
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        char[] ac = PARAMETER_SEPARATORS;
        int j = PARAMETER_SEPARATORS.length;
        int i = 0;
        while (i < j) {
            char separator = ac[i];
            if (c == separator) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String parseSqlStatementIntoString(String sql) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, null);
    }

    public static String substituteNamedParameters(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
    }

    public static Object[] buildValueArray(String sql, Map paramMap) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.buildValueArray(parsedSql, new MapSqlParameterSource(paramMap), null);
    }

    public static Object[] buildValueArray(String sql, Object bean) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.buildValueArray(parsedSql, new BeanPropertySqlParameterSource(bean), null);
    }
}

