/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db.impl;

import com.coreframework.db.impl.TimeoutHandler;
import com.coreframework.log.Logger;
import com.mysql.jdbc.MySQLConnection;
import java.sql.Connection;

public class MysqlTimeout
implements TimeoutHandler {
    @Override
    public boolean handle(Connection conn) throws Throwable {
        if (conn.isWrapperFor(MySQLConnection.class)) {
            if (conn.isClosed()) {
                return true;
            }
            conn.unwrap(MySQLConnection.class).abortInternal();
            return true;
        }
        return false;
    }

    @Override
    public boolean validDriver() {
        try {
            Class<?> clz = Class.forName("com.mysql.jdbc.MySQLConnection");
            clz.getMethod("abortInternal", new Class[0]);
            return true;
        }
        catch (Throwable e) {
            Logger.get().console("mysql timeout disabled");
            return false;
        }
    }
}

